<style>
    .phoneItem > span {
	position: relative;
	display: block;
	width: 100%;
        background-color: #fff;
        height: 40px;
        border-radius: 4px;
        font-weight: bold;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 3px 0;
        cursor: pointer;
        border: 2px solid #e6e8ec;
        user-select: none;
    }

    .phoneItem.selected > span::after, 
	.selectedPhoneItem > span::after {
        position: absolute;
        content: 'x';
        font-size: 10px;
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 14px;
        width: 14px;
        background-color: red;
        top: -5px;
        right: -5px;
        border-radius: 50%;
    }

    .selectedPhoneItem > span {
	position: relative;
	display: block;
	width: 100%;
        height: 40px;
        border-radius: 4px;
        font-weight: bold;
		color: #fff;
        display: flex;
		background-color:#1d4491;
        align-items: center;
        justify-content: center;
        margin: 3px;
        border: 2px solid #1d4491;
        cursor: pointer;
        user-select: none;
    }


    .custom-disable {
        background-color: #f8f8f8 !important;
        opacity: 1;
        cursor: not-allowed;
        pointer-events: none;
    }

    .custom-disable::-webkit-outer-spin-button, .custom-disable::-webkit-inner-spin-button {
        -webkit-appearance: none;
    }

    .title {
        margin-top: 25px;
        color: #171d52;
    }

    #phonesContent > .selected > span {
        border: 2px solid #171d52;
    }

    #phonesContent {
        padding: 4px 0;
    }
	.lagom .bootstrap-select .dropdown-menu .inner.show{
        overflow-x: hidden;
    }
    .lagom .bootstrap-select .dropdown-menu:not(.show){
        display: none;
    }
    .lagom .form-control.dropdown-toggle{
       
        background: url('./templates/lagom2/assets/img/arrow-drop.svg');
        background-position-y: 50%;
        background-position-x: calc(100% - 11px);
        background-repeat: no-repeat;
    }
    
	
</style>
<!--
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>
-->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>


<script>
    let phoneInput;
    let simwoodPhoneInput;
    let maxPhonesInput;
    let customFieldId;
    let configurableOptionId;
    let phones;
    
    let tenantNameCustomFieldId;
    let addonProduct;
    let tenantNameOptions;


    $(document).ready(function () {
        customFieldId = '{$customFieldId}';
        configurableOptionId = '{$configurableOptionId}';
        maxPhonesInput = $("input[name='configoption[" + configurableOptionId + "]']");
        maxPhonesInput.addClass("custom-disable");
        maxPhonesInput.attr('readonly', true);
        maxPhonesInput.blur();
        maxPhonesInput.val(0);
        phoneInput = $("textarea[name='customfield[" + customFieldId + "]']");
        phoneInput.closest('div').hide();
        phoneInput.val('');
        
        addonProduct = '{$addonProduct}';
        if(addonProduct) {
            tenantNameCustomFieldId = '{$tenantNameCustomFieldId}';
            tenantNameOptions = "{$tenantNameOptions}";
            $("input[name='customfield[" + tenantNameCustomFieldId + "]']").replaceWith("<select name='customfield[" + tenantNameCustomFieldId + "]'>"+tenantNameOptions+"</select>");
        }
        
        phones = JSON.parse('{json_encode($phones)}');

        $(document).on('click', '.phoneItem', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $(this).addClass('selected');
            }

            updateCustomField($(this).data('phone'));
        })

        $(document).on('click', '.selectedPhoneItem', function () {
            updateCustomField($(this).data('phone'))
            updatePhones();

        })

        $(document).on('change', "input[name='configoption[" + configurableOptionId + "]']", function () {
            $('.phoneItem').each(function () {
                $(this).removeClass('selected');
            });

            $('#selectedPhones').html('');
            phoneInput.val('');
        });


        buildMainContent();

        $(document).on('change', "#numbertype", function () {
            updatePhonesAndAreaCodes();
        });

        $(document).on('change', "#areacode", function () {
            updatePhones();
        });

        $(document).on('click', '.lagom .bootstrap-select .dropdown-menu .dropdown-item', function(){
            let dropdown = $(this).closest('.bootstrap-select').find('.dropdown-toggle');
            dropdown.dropdown('toggle')
        });

        recalctotals();
    });


    function canSelectMore() {
        let maxPhonesCount = parseInt(maxPhonesInput.val());
        let phones = phoneInput.val().split(',');
        phones = phones.filter(function (p) {
            return p.length > 0;
        });

        return phones.length < maxPhonesCount;
    }

    function updateCustomField(phone) {
        phone = phone.toString();
        let phones = phoneInput.val().split(',');
        if (phones.includes(phone)) {
            phones = phones.filter(function (p) {
                return p !== phone;
            });
        } else {
            phones.push(phone);
        }

        phones = phones.filter(function (p) {
            return p.length > 0;
        });


        let content = "";
        phones.forEach(function (phone) {
            let split           = phone.split("-");
            let phoneDisplay    = split[0];
            
            
            content += "<div data-phone = '" + phone + "' class='selectedPhoneItem col-xs-12 col-sm-6 col-md-4 col-lg-3 cp-xlg-3'><span>" + phoneDisplay + "</span></div>";
        });

        $("#selectedPhones").html(content);

        phoneInput.val(phones.join(','));
        maxPhonesInput.val(phones.length);
        maxPhonesInput.value = phones.length;
        recalctotals();
    }

    function buildPhonesContent(code) {
        let phonesContent = '';
        phones.forEach(function (phone) {
            let fullNumber = phone.di_area + phone.di_number;
            let fullNumberWithZero = "0" + fullNumber;
            let subNumber = fullNumber.substring(code.length);
            if ((fullNumber).indexOf(code) === 0) {
                phonesContent += "<div class='phoneItem col-xs-12 col-sm-6 col-md-4 col-lg-3 cp-xlg-3' data-phone=" + fullNumberWithZero + "><span>0" + code + " " + subNumber + "</span></div>";
            }
        });

        if (phonesContent.length === 0) {
            phonesContent = "Unfortunately, there are no numbers available for the selected Area Code. Please choose a different area code."
        }

        return phonesContent;
    }

    function buildMainContent() {
        let container = $('#productConfigurableOptions');

        let areaCodesContent = '';
        let numberType = $('#numbertype').val();
        let code = 0;
        let name = '';

        if (numberType == 'local' || numberType == undefined) {
            let areaCodes = JSON.parse('{json_encode($areaCodes)}');
            areaCodes.forEach(function (area) {
                if (code === 0) {
                    code = area.code;
                    name = area.name;
                }
                areaCodesContent += `{literal}<option value='${area.code}' data-source='${area.source}'>${area.name}</option>{/literal}`;
            });
        } else {
            areaCodesContent = "<option value='333'>(0333)</option><option value='845'>(0845)</option>";
            let areaCodes = JSON.parse('{json_encode($areaCodesNg)}');
            areaCodes.forEach(function (area) {
                if (name.length === 0) {
                    name = area.name;
                }
                areaCodesContent += `{literal}<option value='${area.code}' data-source='${area.source}'>${area.name}</option>{/literal}`;
            });
        }

        let phonesContent = buildPhonesContent(code);
        let headerContent = `Standard {literal}${name}{/literal} Phone Numbers`;
        let content = `
        <div style="margin-top:20px;" class="panel panel-default panel-form">
        	<div class="panel-body">
			<div class="row">
				<div class="col-sm-6 col-md-4">
				    <div class="form-group">
						<label>Country</label>
						<input disabled value="UK (+44)" class="form-control col">
						</select>
				    </div>
				</div>
				<div class="col-sm-6 col-md-4">
				    <div class="form-group">
						<label>Number Type</label>
						<select id="numbertype" class="form-control col">
							<option value="local">Geographic (Local)</option>
							<option value="uk-wide">Non-Geographic (UK-Wide)</option>
						</select>
				    </div>
				</div>
				<div class="col-sm-6 col-md-4">
				    <div class="form-group">
						<label>Area Code</label>
						<select id="areacode" class="form-control col selectpicker" data-live-search="true">
						{literal}${areaCodesContent}{/literal}
						</select>
				    </div>
				</div>
			</div>
			<div><h4 id="phoneHeader" class="title">{literal}${headerContent}{/literal}</h4></div>
			<div id="phonesContent" class="row" style="max-height:500px; overflow-y:auto;">
				{literal}${phonesContent}{/literal}
			</div>
			<div>
				<h4 class="title">Chosen Phone Numbers</h4>
			</div>
			<div class="row" id="selectedPhones"></div>
        </div>
        </div>
        </div>`;
        container.after(content);
    }

    function updatePhonesAndAreaCodes() {
        let numberType = $("#numbertype").val();
        let name = ''
        let areaCodesContent = '';

        if (numberType == 'local' || numberType == undefined) {

            let areaCodes = JSON.parse('{json_encode($areaCodes)}');
            areaCodes.forEach(function (area) {
                if (name.length === 0) {
                    name = area.name;
                }
                areaCodesContent += `{literal}<option value='${area.code}' data-source='${area.source}'>${area.name}</option>{/literal}`;
            });
        } else {
            areaCodesContent = "<option value='333'>(0333)</option><option value='845'>(0845)</option>"
            let areaCodes = JSON.parse('{json_encode($areaCodesNg)}');
            areaCodes.forEach(function (area) {
                if (name.length === 0) {
                    name = area.name;
                }
                areaCodesContent += `{literal}<option value='${area.code}' data-source='${area.source}'>${area.name}</option>{/literal}`;
            });
        }

        $("#phoneHeader").html(`Standard {literal}${name}{/literal} Phone Numbers`);
        $("#areacode").html(areaCodesContent);

        updatePhones();

        $.fn.selectpicker.Constructor.DEFAULTS.styleBase = 'form-control';
        $.fn.selectpicker.Constructor.DEFAULTS.style = '';
        //$("#areacode").selectpicker();
        $("#areacode").selectpicker('refresh');
    }
    
    let cache = [];
    
    function updatePhones() {
        
        let numberType  = $("#numbertype").val();
        let areaCode    =  $("#areacode").val();
        let areaName    =  $("#areacode option:selected").text();
        let areaSource  =  $("#areacode option:selected").data("source");
        
        if(areaSource == "simwood" || areaSource == "magrathea") {
            
            if(!cache[areaCode]) {
                $.ajax({
                    type: 'post',
                    data: {
                        giantResellerAction: "getPhones",
                        areaCode: areaCode,
                    },
                    success: function(responseJson) {
                        var response = jQuery.parseJSON(responseJson);
                        
                        if(Array.isArray(response)) {
                            response.forEach(function(numberData){
                                if(numberData.number) {
                                    phones.push(
                                        {
                                            di_id:0, 
                                            di_di_country: numberData.country_code, 
                                            di_area: areaCode, 
                                            fullNumber: numberData.number+"-"+numberData.source,
                                            source: numberData.source
                                        }
                                    );
                                }
                            });
                        }
                        
                        cache[areaCode] = true;
                        displayPhones(areaCode, areaName);
                    }
                });
            } else {
                displayPhones(areaCode, areaName);
            }
        } else {
            displayPhones(areaCode, areaName);
        }
    }
    
    function displayPhones(areaCode, areaName) {
        
        let phonesContent = '';
        let selectedPhones = phoneInput.val().split(',');
        phones.forEach(function (phone) {
            let fullNumber = "";
            if(phone.fullNumber) {
                fullNumber = phone.fullNumber;
            } else {
                fullNumber = phone.di_area + phone.di_number;
            }
            let fullNumberWithZero = "0" + fullNumber;
            
            let subNumber   = fullNumber.substring(areaCode.length);
            let split       = subNumber.split("-");
            subNumber       = split[0];
            
            let divClass = 'phoneItem col-xs-12 col-sm-6 col-md-4 col-lg-3 cp-xlg-3'
            if (selectedPhones.includes(fullNumberWithZero)) {
                divClass = 'phoneItem col-xs-12 col-sm-6 col-md-4 col-lg-3 cp-xlg-3 selected';
            }

            if ((fullNumber).indexOf(areaCode) === 0) {
                phonesContent += "<div class='" + divClass + "' data-phone=" + fullNumberWithZero + " data-source=" + phone.source + "><span>0" + areaCode + " " + subNumber + "</span></div>";
            }
        });

        if (phonesContent.length === 0) {
            phonesContent = "Unfortunately, there are no numbers available for the selected Area Code. Please choose a different area code or create a support ticket and request a new telephone range to be allocated to this area code."
        }

        $("#phoneHeader").html(`Standard {literal}${areaName}{/literal} Phone Numbers`);
        $("#phonesContent").html(phonesContent);
    }

    $(document).ready(function() {
        updatePhonesAndAreaCodes();
    });


</script>