<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.5.0/chart.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.4/js/bootstrap-datepicker.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.4/css/bootstrap-datepicker.min.css"
      rel="stylesheet"/>
<script src="modules/addons/GiantVoIPResellerBilling/templates/Client/js/inputMask/jquery.inputmask.js"></script>
<script src="modules/addons/GiantVoIPResellerBilling/templates/Client/js/jquery-ui/jquery-ui.min.js"></script>
<link rel="stylesheet" href="modules/addons/GiantVoIPResellerBilling/templates/Client/js/jquery-ui/jquery-ui.min.css">
<script src="modules/addons/GiantVoIPResellerBilling/templates/Client/js/jquery-signature/jquery.signature.js"></script>
<script src="modules/addons/GiantVoIPResellerBilling/templates/Client/js/index.js"></script>
<link rel="stylesheet" href="modules/addons/GiantVoIPResellerBilling/templates/Client/css/index.css">
<div class="container">
    <div class="row">
        <div class="col-md-3">
            <button class="tile" data-name="callLog" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-reports.png"
                        alt="View Call Logs">Call Logs
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="destination" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-missed-call.png"
                        alt="Manage your telephone numbers">Telephone Numbers
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="smsLog" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-send-sms.png"
                        alt="View SMS Logs">SMS Logs
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="ivr" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-ivr.png"
                        alt="Manage IVR(s)">IVR(s)
            </button>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <button class="tile" data-name="extension" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-user-update.png"
                        alt="Create or Edit your Extensions">Extensions
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="voicemail" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-voicemail.png"
                        alt="View Voicemail">Voicemail
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="phone" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-extension-added.png"
                        alt="Autoprovision hardware">Autoprovisioning
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="shortNumber" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-short-numbers.png"
                        alt="Short dialling numbers">Short Numbers
            </button>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <button class="tile" data-name="huntList" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-huntlists.png"
                        alt="Manage Hunt lists">Hunt Lists
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="customDestination" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-custom-destination.png"
                        alt="Forwarding custom destinations">Forwarding Destinations
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="featureCode" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-feature-codes.png"
                        alt="Feature Codes">Feature Codes
            </button>
        </div>
        <div class="col-md-3">
            <button class="tile" data-name="queue" data-toggle="modal" data-target="#giantModal"><img
                        src="./modules/addons/GiantVoIPResellerBilling/lib/Img/Icons/giant-email-icon-queue.png" alt="Test">Queues
            </button>
        </div>
    </div>

    
    <br>
<br>
<br>
<br>
    <div class="row">

       
</div>
<!-- modal -->
<div class="modal fade" id="giantModal" tabindex="-1" role="dialog" aria-labelledby="giantModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="giantModalTitle">Extensions</h5>
                <small class="modal-description" id="giantModalDescription"></small>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div id="giantModalSpinnerDiv" class="giantModalPanel">
                    <i class="fas fa-spinner fa-spin"></i>
                </div>
                <div id="giantModalListDiv" class="giantModalPanel">
                    <div id="giantModalAlertDiv">
                        <div id="giantModalAlert" class="alert alert-danger" role="alert">

                        </div>
                    </div>
                    <div id="giantModalListTableDiv">
                        <table id="giantModalList">
                            <thead id="giantModalListHead">
                            </thead>
                            <tbody id="giantModalListBody">
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="giantModalAddFormDiv" class="giantModalPanel">
                    <form id="giantModalAddForm" class="modalForm" method="post">

                    </form>
                </div>
                <div id="giantModalQrDiv" class="giantModalPanel">
                    <form id="giantModalSendEmailForm" class="modalForm" method="post">

                    </form>
                </div>
                <div id="giantModalAdditionalDataDiv" class="giantModalPanel">

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


<h4>Related phone numbers</h4>
<div class="row" style="max-height: 500px; margin-right: 0; margin-left: 0; overflow-y:auto;">
    {foreach from=$phones item=phone}
        <div class="col-xs-6 col-sm-3 phoneItem">{$phone}</div>
    {/foreach}
    {if $numberAddonUrl}
        <a href="{$numberAddonUrl}" class="col-xs-6 col-sm-3 phoneItem">Add New Numbers</a>
    {/if}
</div>
<br/>


{if $showChart}
    <br/>
    <br/>
    <br/>
    <div style="padding: 20px;" class="panel panel-default">
        <canvas id="myChart" height="150"></canvas>
    </div>
{/if}
<br/>
<h4><br/>Calls Information</h4>
<hr/>
<div class="row">
    <div style="font-weight: bold" class="col-md-3">Next Due Date:</div>
    <div style="font-weight: bold;" class="col-md-3">{$nextDueDate}</div>
</div>
<hr/>
<div>
    <h5><br/>Current Billing Period</h5>
    <div class="panel panel-default">
        <div class="panel-body">
            <table class="table table-list dataTable no-footer"
                   style="border-collapse:collapse; width:100%;">
                <thead>
                <tr>
                    <th>Tenant ID</th>
                    <th>Calls Length (min)</th>
                    <th>Inbound Calls</th>
                    <th>Outbound Calls</th>
                    <th>Date</th>
                    <th>Amount</th>
                </tr>
                </thead>
                <tbody>
                {if $currentBilling}
                    <td>{$currentBilling->tenantId}</td>
                    <td>{$currentBilling->callsLength}</td>
                    <td>{$currentBilling->inboundCalls}</td>
                    <td>{$currentBilling->outboundCalls}</td>
                    <td>{$currentBilling->dateFrom} - {$currentBilling->dateTo}</td>
                    <td>{$currentBilling->amount}</td>
                {else}
                    <div>No Current Billing</div>
                {/if}
                </tbody>
            </table>
        </div>
    </div>
</div>
<hr/>
<h4>Billing History</h4>
<div class="panel panel-default">
    <div class="panel-body">
        <table id="productTable" class="table table-list dataTable no-footer"
               style="border-collapse:collapse; width:100%;">
            <thead>
            <tr>
                <th>Tenant ID</th>
                <th>Date From - To</th>
                <th>Calls Length</th>
                <th>Calls Amount</th>
                <th>Amount</th>
                <th>Status</th>
            </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>


<style>
    .phoneItem {
        width: 24%;
        margin: 3px;
        height: 40px;
        border-radius: 4px;
        font-weight: bold;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 2px solid #e6e8ec;
        cursor: pointer;
        user-select: none;
    }

    @media (max-width: 568px) {
        .phoneItem {
            width: 46%;
        }
    }
</style>

<script>
    $(document).ready(function () {
        $('#productTable').DataTable({
            "dom": '<"listtable"fit>pl',
            "processing": true,
            "serverSide": true,
            "ajax": "index.php?m=GiantVoIPResellerBilling&action=getbillings&tenantId={$tenantId}",
            "searching": true,
            "order": [0, 'desc']
        });

        //fix numbers in Additional Information
        var numbersSpan = $("#additionalinfo").find(".list-info-text").last();
        var numbers = numbersSpan.html();
        numbers = numbers.replaceAll("-simwood", "");

        numbersSpan.html(numbers);
    });
    var labels = JSON.parse('{$labels}');
    var inboundCalls = JSON.parse('{$inboundCalls}');
    var outboundCalls = JSON.parse('{$outboundCalls}');


    if (inboundCalls.length > 0 && outboundCalls.length > 0) {
        var ctx = document.getElementById('myChart').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [{
                    lineTension: 0.4,
                    label: 'Outbound Calls',
                    data: outboundCalls,
                    fill: 'start',
                    backgroundColor:
                        'rgba(52, 180, 210, 0.7)',

                    borderColor:
                        'rgb(52, 132, 210)',

                    borderWidth: 1,
                }, {
                    lineTension: 0.4,
                    label: 'Inbound Calls',
                    data: inboundCalls,
                    fill: 'start',
                    backgroundColor: 'rgba(96, 78, 188, 0.7)',
                    borderColor: 'rgb(96, 78, 212)',
                    borderWidth: 1,
                }]
            },
            options: {
                plugins: {
                    legend: {
                        position: "bottom"
                    },
                    title: {
                        display: true,
                        text: 'Call Statistics',
                        font: {
                            size: 16
                        }
                    },
                    subtitle: {
                        display: true,
                        text: "Calls per day for current cycle",
                        padding: {
                            bottom: 10
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            display: false,
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        },
                        ticks: {
                            display: false
                        }
                    }
                }
            }
        });
    }

</script>
