var modalDescriptions = {
    extension: "This list of extensions for your VoIP tenant account are shown along with the callerid,<br> username, password associated with each of your extensions.",
    callLog: "This modal allows you to check your telephone call logs, with unique call references numbers,<br> should you need to report any issues. Aswell as listen to your call recordings if enabled on each telephone number.<br> Use the From and To date pickers to filter your call log or the search bar.",
    destination: "Change your telephone number destinations, label them or even enable/disable call recording.",
    port: "This is an automated number port submission (Telephone number transfer), if accepted this request will be fulfilled autonomously.<br><b>PLEASE NOTE:</b> If you currently have ADSL or FTTC broadband services assigned to this number, your service will cease when the port is completed.",
    ivr: "Individualised Interactive Voice response system. set up and change how IVR(s)<br> work on your phone system like changing destination for every key press, for example “Press 1 for sales”,<br> this can be set to transfer callers to your newly created sales queue.",
    extension: "Create, edit, delete extensions at any time. This list of extensions for your VoIP tenant<br> account are shown along with the callerid, username, password associated with each of your extensions.",
    voicemail: "Create and edit your voicemail box(s), enable voicemail to email capabilities<br> and choose your Voicemail Greetings. With Voicemail to Email/Message Configuration. ",
    phone: "Autoprovision your telephony hardware and enable rapid hardware deployment via auto-setup of new hardware.",
    condition: "Take control by routing calls to the destination of your choice based<br> on the time and date. Holidays coming up? Divert your calls until you return to the office, all year round.",
    huntList: "Telephone Ring Group Management – Have your phone system call multiple users & devices at once.",
    media: "Media files are used for music on hold, welcome messages and for every kind of message<br> played to the user. Use this modal to upload, replace, edit or delete your media file collection.",
    musicOnHold: "Music on hold (MOH) allows to select which file to use for MOH. You can add multiple Music on hold tracks<br> and medial files to create a music or announcement playlist while callers are either on hold or are currently in one of your call queues.",
    queue: "Automated Call Queueing Facility – never miss a call – facilitate multiple system calls<br> at any given time. Create, edit and delete your inbound call queues directly, program which extensions are<br> to be called when trying to connect to a user within a specific queue, change queue announcements.",
    customDestination: "Create or manage new custom destination numbers, this is useful for creating new diverts for your account.",
    featureCode: "More functionality coming soon.",
    shortNumber: "Program your own short numbers for quick dialling of custom destinations.",
    phoneBook: "Synchronize your handsets with the same cloud phone book, share your contacts amongst the rest of the team.",
    smsLog: "Send SMS to any UK telephone number, you can also set up a full SMS campaign via the full VoIP portal which you have access to.",
    apiAccess: "API Access.",
};

var addFormData = {
//extension=====================================================================        
    extension: [
        {
            name: "ex_info",
            display: "Info",
            type: "info",
            value: "dynamic",
        },
        {
            name: "ex_name",
            display: "Name",
            description: "Extension name e.g. 'Jon Doe' or 'Jon Doe - Director'.",
        },
        {
            name: "ex_number",
            display: "Extension Number",
            description: "Extension Number e.g. '501', '5000'. This is used for internal dialling and routing. <br><b>PLEASE NOTE:</b> We advise that you do not create extensions that match any emergency service telephone numbers e.g '101, 999, 112 etc.'",
        },
        {
            name: "ex_cidnum",
            display: "Telephone Number for outbound presentation",
            description: "Please select one of your provided telephone numbers to be presented to the callee when you call them.",
            options: "dynamic",
        },
        {
            name: "ex_mailbox",
            display: "Voicemail",
            description: "If you would like voicemail to be accessable to this extension, please select it from the dropdown above.",
            options: "dynamic",
        },
        /*
        {
            name:       "ex_tech",
            display:    "Tech",
            options: {
                SIP:    "SIP",
                PJSIP:  "PJSIP"
            }
        },
        * 
        */
        {
            name: "ex_alertemail",
            display: "Alert notification email",
            description: "If you would like extension related emails to be sent to an email address, please enter it here.",
        },
        {
            name: "ex_alertwhenoffline",
            display: "Extension online/offline alerts",
            description: "This enables email notifications for the availibility status of this extension e.g 'Extension Offline' or 'Extension online'.",
            options: {
                off: "Disabled",
                on: "Enabled",
            }
        },
        {
            name: "password",
            display: "Password",
            description: "The password for this extension user, either enter your own or click the generate button to create a secure password for this extension.",
            type: "password"
        },
    ],

//customDestination=============================================================   
    customDestination: [
        {
            name: "cu_name",
            display: "Name",
            description: "This is the label for your custom destination/forwarding destination, for example: 'Jon Doe's Mobile'",
        },
        {
            name: "cu_param1",
            display: "Destination number",
            description: "Please enter the destination number e.g '03330000000' or '07900000000'.",
        },
    ],

//phone(autoprovisioning)=======================================================   
    phone: [
        {
            name: "ph_name",
            display: "Name",
            description: "Unique label for your provisioned device e.g 'Jon Doe's Yealink T46S' or 'Main Office Phone'.",
        },
        {
            name: "ph_mac",
            display: "MAC",
            description: "Please enter the MAC Address for this device, you can usually find this on the back or underside of your hardware.",
            mask: {regex: "([0-9A-Fa-f]{2}:){5}([0-9A-Fa-f]{2})"},
        },
        {
            name: "ph_pm_id",
            display: "Phone Model",
            description: "Please select from the list of supported autoprovisionable devices, Yealink is currently the only manufacturarer that we are able to deploy with 'Zero-touch'.",
            options: "dynamic",
            onChange: function (event) {

                var linesCount = $(this).find('option:selected').data("pm_endline");
                $('[name^="ph_line"]').prop('disabled', false);
                for (var i = linesCount; i < 10; i++) {
                    $('[name="ph_line' + (i + 1) + '_ex_id"]').prop('disabled', true);
                }
            }
        },
        {
            name: "ph_line0_ex_id",
            display: "Line 1 Extension",
            description: "Please select your 1st phone line for this device. e.g '101 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line1_ex_id",
            display: "Line 2 Extension",
            description: "Please select your 2nd phone line for this device. e.g '102 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line2_ex_id",
            display: "Line 3 Extension",
            description: "Please select your 3rd phone line for this device. e.g '103 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line3_ex_id",
            display: "Line 4 Extension",
            description: "Please select your 4th phone line for this device. e.g '104 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line4_ex_id",
            display: "Line 5 Extension",
            description: "Please select your 5th phone line for this device. e.g '105 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line5_ex_id",
            display: "Line 6 Extension",
            description: "Please select your 6th phone line for this device. e.g '106 - Jon Doe'",
            options: "dynamic",
        },

    ],
//huntList======================================================================
    huntList: [
        {
            name: "hu_name",
            display: "Name",
            description: "Please label your new Hunt List e.g 'Sales Team' or 'Support Team' etc.",
        },
        {
            name: "hu_extensions",
            display: "Extensions",
            description: "Please add which extensions you would like to be called when callers are diverted to your Huint List.",
            options: "dynamic",
            type: "checkbox"
        },
    ],
//shortNumber===================================================================
    shortNumber: [
        {
            name: "sn_number",
            display: "Number",
            description: "Please enter your new short number code, after this new short number has been created, you can dial the short number code to dial your real destination.",
        },
        {
            name: "sn_destnumber",
            display: "Destination Number",
            description: "Please enter the destination number e.g '03330000000' or '07900000000'.",
        },
        {
            name: "sn_comment",
            display: "Comment",
            description: "Please name your new short number e.g 'Jon Doe Mobile Speed Dial' etc.",
        },

    ],
//featureCode==============================================================================
    featureCode: [
        {
            name: "fe_code",
            display: "Code",
            description: "Please enter your new feature code number e.g '659*'",
        },
        {
            name: "fe_comment",
            display: "Comment",
            description: "Please name your new Feature code e.g 'Withheld dial",
        },
    ],

//ivr===========================================================================
    ivr: [
        {
            name: "iv_name",
            display: "Name",
            description: "Please name your new IVR e.g 'Main Welcome IVR'.",
        },
        {
            name: "iv_me_id",
            display: "Media File",
            description: "Please select your IVR welcome message here, this is the media file your caller will hear first before selecting an option.",
            options: "dynamic",
        },
        {
            name: "iv_timeout",
            display: "Timeout",
            description: "Enter the number of seconds your caller has to make their IVR number selection.",
        },
        {
            name: "iv_maxloops",
            display: "Max Loops",
            description: "Enter the maximum number of IVR loops given to the caller before the caller is disconnected for either not selecting an option or trying to select an invalid option.",
        },
        {
            name: "iv_ivr_1",
            display: "Pressing 1",
            description: "Enter the destination to route your caller to when they press <b>'1'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_2",
            display: "Pressing 2",
            description: "Enter the destination to route your caller to when they press <b>'2'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_3",
            display: "Pressing 3",
            description: "Enter the destination to route your caller to when they press <b>'3'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_4",
            display: "Pressing 4",
            description: "Enter the destination to route your caller to when they press <b>'4'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_5",
            display: "Pressing 5",
            description: "Enter the destination to route your caller to when they press <b>'5'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_6",
            display: "Pressing 6",
            description: "Enter the destination to route your caller to when they press <b>'6'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_7",
            display: "Pressing 7",
            description: "Enter the destination to route your caller to when they press <b>'7'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_8",
            display: "Pressing 8",
            description: "Enter the destination to route your caller to when they press <b>'8'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_9",
            display: "Pressing 9",
            description: "Enter the destination to route your caller to when they press <b>'9'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_0",
            display: "Pressing 0",
            description: "Enter the destination to route your caller to when they press <b>'0'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_star",
            display: "Pressing Star",
            description: "Enter the destination to route your caller to when they press <b>'*'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_sharp",
            display: "Pressing Sharp",
            description: "Enter the destination to route your caller to when they press <b>'#'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
    ],
//voicemail
    voicemail: [
        {
            name: "fullname",
            display: "Name",
            description: "Please name your new Voicemail box e.g 'Jon Doe Mailbox' etc.",
        },
        {
            name: "mailbox",
            display: "Mailbox",
            description: "Please name your new Voicemail box e.g 'Jon Doe Mailbox' etc.",
        },
        {
            name: "password",
            display: "PIN",
            description: "Enter a PIN code for secure access to this mailbox e.g '0000' or '1234' etc.",
        },
        {
            name: "welcomeoption",
            display: "Greeting",
            description: "Please select your welcome option for this voicemail e.g 'Automatic with no instructions.",
            options: {
                "Auto": "Automatic with no instructions",
                "Silent": "Always silent",
                "AutoInst": "Automatic with instructions",
                "Inst": "Only instructions",
            }
        },
        {
            name: "email",
            display: "Email",
            description: "If you would like your voicemail messages to be delivered to an email, please enter the your email here. You can enter multiple email destinations seprated by a comma.",
        },
        {
            name: "review",
            display: "Allow message review",
            description: "Permit the caller to be able to review their recorded message before confirming it.",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "saycid",
            display: "Say Caller ID",
            description: "It controls if the Caller ID of the caller ID needs to be played before the voicemail message.",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
    ],
//queue
    queue: [
        //config
        {
            name: "qu_info_config",
            display: "Info",
            type: "info",
            value: "Configuration",
        },
        {
            name: "qu_name",
            display: "Name",
            description: "Please enter a name for the Queue e.g 'Failover Sales Queue' etc.",
        },
        /*    {
                name:       "xxx1",
                display:    "Play to the caller",
                options: {
                    1:     "Music on Hold",
                    2:     "Ringing",
                    3:     "Music on hold and then ringing once an agent is ringing",
                }
            },*/
        {
            name: "qu_ringinuse",
            display: "Ring when in use/offline",
            description: "Would you like this queue to attempt to dial agent extensions while they're offline or currently on a call wioth another caller?",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "qu_timeout",
            display: "Timeout",
            description: "Please enter a queue maximum duration, this means the maximum time any caller can stay in th your queue until they are disconnected or diverted to your 'On Timeout' destination below.",
        },
        {
            name: "qu_on_timeout",
            display: "On timeout",
            description: "Select where to divert timed out callers in your queue.",
            options: "dynamic",
        },
        //agents
        {
            name: "qu_info_agents",
            display: "Info",
            description: "description pending",
            type: "info",
            value: "Agents",
        },
        {
            name: "strategy",
            display: "Strategy",
            description: "<b>Ring All:</b> rings all available extensions until one answers<br><b>Round Robin:</b> rings one extension at time, remembering which one was last ring<br><b>Random:</b> rings a random extension<br><b>Weighted Random:</b> rings a random extension but uses the agent's penalty as a weight<br><b>Least Recent:</b> ring the extension which was least recently called by this queue<br><b>Fewest Calls:</b> rings the extension with fewest completed calls from this queue",
            options: {
                RINGALL: "Ring all",
                RRMEMORY: "Roundrobin",
                RANDOM: "Random",
                WRANDOM: "Weighted Random",
                LEASTRECENT: "Least Recent",
                FEWESTCALLS: "Fewest Calls",
            }
        },
        {
            name: "agents",
            display: "Agents",
            description: "description pending",
            options: "dynamic",
            type: "multipleSelect",
            description: "Please select which agents you would like to be members of this Queue.",
        },
        {
            name: "qu_parameters",
            display: "Available Agent ringing",
            description: "Select the number of times you would like each agent to be called by the queue.",
            options: {
                tr: "Multiple Times",
                ntr: "Only Once",
            }
        },
        {
            name: "timeout",//q
            display: "Agent timeout",
            description: "How many seconds to ring an agent's phone before moving on or dial it again if the queue timeout is longer",
            'default': 30,
        },
        {
            name: "retry",//q
            display: "Wait time for retry",
            description: "After an agent has been dialed, how many seconds to wait before dialing it again",
            'default': 15,
        },
        //Periodic Announce
        {
            name: "qu_info_periodic_announce",
            display: "Info",
            type: "info",
            value: "Periodic Announce",
        },
        {
            name: "periodic_announce", //q
            display: "Periodic Announce",
            description: "Select the announces to be played. If you don't want announces, set to 0 (zero) the above Announce Frequency",
            options: "dynamic",
            type: "multipleSelect",
        },
        //Position/Time Announce
        {
            name: "qu_info_position",
            display: "Info",
            description: "description pending",
            type: "info",
            value: "Position/Time Announce",
        },
        {
            name: "announce_frequency", //q
            display: "Announce Frequency",
            description: "Number of seconds between announcements, set to 0 to completely disable any announcement of these messages",
        },
        {
            name: "announce_holdtime",//q
            display: "Announce holdtime",
            description: "Choose to announce the calculated hold time before being connected",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "announce_round_seconds",//q
            display: "Announce Round Seconds",
            description: "Rounding level for wait-time announcements. If 0, only minutes, not seconds, are announced. (For example, when set to 30, a wait time of 2:34 will be rounded to 2:30.)",
            options: {
                "0": "No rounding",
                "60": "Only minutes",
                "1": "1",
                "5": "5",
            }
        },
        {
            name: "announce_position",//q
            display: "Announce position",
            description: "Choose to announce the position of the caller in the queue",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "qu_youarenext_me_id",
            display: '"You are the next" message',
            description: "Please choose the media file to use for this announcement.",
            options: "dynamic"
        },
        {
            name: "qu_thereare_me_id",
            display: '"There are" message',
            description: "Please choose the media file to use for this announcement.",
            options: "dynamic"
        },
        {
            name: "qu_callswaiting_me_id",
            display: '"Calls waiting" message',
            description: "Please choose the media file to use for this announcement.",
            options: "dynamic"
        },
        {
            name: "qu_thankyou_me_id",
            display: '"Thank you" message',
            description: "Please choose the media file to use for this announcement.",
            options: "dynamic"
        },
        {
            name: "qu_holdtime_me_id",
            display: '"The current est. holdtime is" message',
            description: "Please choose the media file to use for this announcement.",
            options: "dynamic"
        },
    ],
    //port
    port: "dynamic",
    //smsLog
    smsLog: [
        {
            name: "smsFrom",
            display: "From",
            options: "dynamic",
            description: "Please choose the 'From' field for this SMS.",
        },
        {
            name: "smsTo",
            display: "To",
            description: "Please enter the recipients' telephone number to send this SMS to e.g '07900000000' or '+447900000000'",
        },
        {
            name: "smsMessage",
            display: "Message",
            type: "textarea",
            description: "Please enter your SMS content, limited to 165 characters.",
        },
    ]

//END addFormData=========================================================================
};

//==============================================================================
var editFormData = {
//extension=====================================================================        
    extension: [
        {
            name: "ex_id",
        },
        {
            name: "ex_name",
            display: "Name",
            description: "Extension name e.g. 'Jon Doe' or 'Jon Doe - Director'.",
        },
        {
            name: "ex_cidnum",
            display: "Telephone Number for outbound presentation",
            options: "dynamic",
            description: "Telephone Number for outbound presentation",
        },
        {
            name: "ex_mailbox",
            display: "Voicemail",
            description: "If you would like voicemail to be accessable to this extension, please select it from the dropdown above.",
            options: "dynamic",
        },
        {
            name: "ex_alertemail",
            display: "Alert notification email",
            description: "If you would like extension related emails to be sent to an email address, please enter it here.",
        },
        {
            name: "ex_alertwhenoffline",
            display: "Extension online/offline alerts",
            description: "This enables email notifications for the availibility status of this extension e.g 'Extension Offline' or 'Extension online'.",
            options: {
                off: "Disabled",
                on: "Enabled",
            }
        },
        {
            name: "password",
            display: "Password",
            description: "The password for this extension user, either enter your own or click the generate button to create a secure password for this extension.",
            type: "password"
        },
    ],
//customDestination=============================================================        
    customDestination: [
        {
            name: "cu_id",
        },
        {
            name: "cu_name",
            display: "Name",
            description: "This is the label for your custom destination/forwarding destination, for example: 'Jon Doe's Mobile'",
        },
        {
            name: "cu_param1",
            display: "Destination number",
            description: "Please enter the destination number e.g '03330000000' or '07900000000'.",
        },

    ],

//huntList=============================================================        
    huntList: [
        {
            name: "hu_id",
        },
        {
            name: "hu_name",
            display: "Name",
            description: "Please label your new Hunt List e.g 'Sales Team' or 'Support Team' etc.",
        },
        {
            name: "hu_extensions",
            display: "Extensions",
            description: "Please add which extensions you would like to be called when callers are diverted to your Huint List.",
            options: "dynamic",
            type: "checkbox"
        },

    ],
//destination===================================================================        
    destination: [
        {
            name: "di_id",
        },
        {
            name: "di_comment",
            display: "Comment",
            description: "Enter a label for this telephone number e.g 'Main Company Line'",

        },
        {
            name: "di_recording",
            display: "Recording",
            description: "Enable or disable call recording for this telephone number.",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "di_destination",
            display: "Destination",
            description: "Please select a destination for this telephone number, you can select from created extensions, hunt lists, IVR(s), Queues and much more.",
            options: "dynamic",
            type: "multipleSelect",
        },
    ],
//phone
    phone: [
        {
            name: "ph_id",
        },
        {
            name: "ph_name",
            display: "Name",
            description: "Unique label for your provisioned device e.g 'Jon Doe's Yealink T46S' or 'Main Office Phone'.",
        },
        {
            name: "ph_mac",
            display: "MAC",
            description: "Please enter the MAC Address for this device, you can usually find this on the back or underside of your hardware.",
            mask: {regex: "([0-9A-Fa-f]{2}:){5}([0-9A-Fa-f]{2})"},
        },
        {
            name: "ph_pm_id",
            display: "Phone Model",
            description: "Please select from the list of supported autoprovisionable devices, Yealink is currently the only manufacturarer that we are able to deploy with 'Zero-touch'.",
            options: "dynamic",
            onChange: function (event) {
                var linesCount = $(this).find('option:selected').data("pm_endline");
                $('[name^="ph_line"]').prop('disabled', false);
                for (var i = linesCount; i < 10; i++) {
                    $('[name="ph_line' + (i + 1) + '_ex_id"]').prop('disabled', true);
                }
            }
        },
        {
            name: "ph_line0_ex_id",
            display: "Line 1 Extension",
            description: "Please select your 1st phone line for this device. e.g '101 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line1_ex_id",
            display: "Line 2 Extension",
            description: "Please select your 1st phone line for this device. e.g '102 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line2_ex_id",
            display: "Line 3 Extension",
            description: "Please select your 1st phone line for this device. e.g '103 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line3_ex_id",
            display: "Line 4 Extension",
            description: "Please select your 1st phone line for this device. e.g '104 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line4_ex_id",
            display: "Line 5 Extension",
            description: "Please select your 1st phone line for this device. e.g '105 - Jon Doe'",
            options: "dynamic",
        },
        {
            name: "ph_line5_ex_id",
            display: "Line 6 Extension",
            description: "Please select your 1st phone line for this device. e.g '106 - Jon Doe'",
            options: "dynamic",
        },
    ],
    shortNumber: [
        {
            name: "sn_id",
        },
        {
            name: "sn_number",
            display: "Number",
            description: "Please enter your new short number code, after this new short number has been created, you can dial the short number code to dial your real destination.",
        },
        {
            name: "sn_destnumber",
            display: "Destination Number",
            description: "Please enter the destination number e.g '03330000000' or '07900000000'.",
        },
        {
            name: "sn_comment",
            display: "Comment",
            description: "Please name your new short number e.g 'Jon Doe Mobile Speed Dial' etc.",
        },

    ],
//featureCode==============================================================================
    featureCode: [
        {
            name: "fe_id",
        },
        {
            name: "fe_code",
            display: "Code",
            description: "Please enter your new feature code number e.g '659*'",
        },
        {
            name: "fe_comment",
            display: "Comment",
            description: "Please name your new Feature code e.g 'Withheld dial",
        },
    ],

//ivr
    ivr: [
        {
            name: "iv_id",
        },
        {
            name: "iv_name",
            display: "Name",
            description: "Please name your new IVR e.g 'Main Welcome IVR'.",
        },
        {
            name: "iv_me_id",
            display: "Welcome message",
            description: "Please select your IVR welcome message here, this is the media file your caller will hear first before selecting an option.",
            options: "dynamic",
        },
        {
            name: "iv_timeout",
            display: "Timeout",
            description: "Enter the number of seconds your caller has to make their IVR number selection.",
        },
        {
            name: "iv_maxloops",
            display: "Max Loops",
            description: "Enter the maximum number of IVR loops given to the caller before the caller is disconnected for either not selecting an option or trying to select an invalid option.",
        },
        {
            name: "iv_ivr_1",
            display: "Pressing 1",
            description: "Enter the destination to route your caller to when they press <b>'1'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_2",
            display: "Pressing 2",
            description: "Enter the destination to route your caller to when they press <b>'2'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_3",
            display: "Pressing 3",
            description: "Enter the destination to route your caller to when they press <b>'3'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_4",
            display: "Pressing 4",
            description: "Enter the destination to route your caller to when they press <b>'4'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_5",
            display: "Pressing 5",
            description: "Enter the destination to route your caller to when they press <b>'5'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_6",
            display: "Pressing 6",
            description: "Enter the destination to route your caller to when they press <b>'6'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_7",
            display: "Pressing 7",
            description: "Enter the destination to route your caller to when they press <b>'7'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_8",
            display: "Pressing 8",
            description: "Enter the destination to route your caller to when they press <b>'8'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_9",
            display: "Pressing 9",
            description: "Enter the destination to route your caller to when they press <b>'9'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_0",
            display: "Pressing 0",
            description: "Enter the destination to route your caller to when they press <b>'0'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_star",
            display: "Pressing Star",
            description: "Enter the destination to route your caller to when they press <b>'*'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
        {
            name: "iv_ivr_sharp",
            display: "Pressing Sharp",
            description: "Enter the destination to route your caller to when they press <b>'#'</b> when presented with options on their keypad.",
            options: "dynamic",
        },
    ],

//voicemail
    voicemail: [
        {
            name: "uniqueid",
        },
        {
            name: "fullname",
            display: "Name",
            description: "Please name your new Voicemail box e.g 'Jon Doe Mailbox' etc.",
        },
        {
            name: "mailbox",
            display: "Mailbox",
            description: "Please name your new Voicemail box e.g 'Jon Doe Mailbox' etc.",
        },
        {
            name: "password",
            display: "PIN",
            description: "Enter a PIN code for secure access to this mailbox e.g '0000' or '1234' etc.",
        },
        {
            name: "welcomeoption",
            display: "Greeting",
            description: "Please select your welcome option for this voicemail e.g 'Automatic with no instructions.",

            options: {
                "Auto": "Automatic with no instructions",
                "Silent": "Always silent",
                "AutoInst": "Automatic with instructions",
                "Inst": "Only instructions",
            }
        },
        {
            name: "email",
            display: "Email",
            description: "If you would like your voicemail messages to be delivered to an email, please enter the your email here. You can enter multiple email destinations seprated by a comma.",
        },
        {
            name: "review",
            display: "Allow message review",
            description: "Permit the caller to be able to review their recorded message before confirming it.",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "saycid",
            display: "Say Caller ID",
            description: "It controls if the Caller ID of the caller ID needs to be played before the voicemail message.",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
    ],
//queue
    queue: [
        {
            name: "qu_id",
        },
        //config
        {
            name: "qu_info_config",
            display: "Info",
            type: "info",
            value: "Configuration",
        },
        {
            name: "qu_name",
            display: "Name",
        },
        /*    {
                name:       "xxx1",
                display:    "Play to the caller",
                options: {
                    1:     "Music on Hold",
                    2:     "Ringing",
                    3:     "Music on hold and then ringing once an agent is ringing",
                }
            },*/
        {
            name: "qu_ringinuse",
            display: "Ring when in use/offline",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "qu_timeout",
            display: "Timeout",
        },
        {
            name: "qu_on_timeout",
            display: "On timeout",
            options: "dynamic",
        },
        //agents
        {
            name: "qu_info_agents",
            display: "Info",
            type: "info",
            value: "Agents",
        },
        {
            name: "strategy",
            display: "Strategy",
            options: {
                RINGALL: "Ring all",
                RRMEMORY: "Roundrobin",
                RANDOM: "Random",
                WRANDOM: "Weighted random",
                LEASTRECENT: "Least Recent",
                FEWESTCALLS: "Fewest Calls",
            }
        },
        {
            name: "agents",
            display: "Agents",
            options: "dynamic",
            type: "multipleSelect",
            description: "test agents description",
        },
        {
            name: "qu_parameters",
            display: "Available Agent ringing",
            options: {
                tr: "Multiple Times",
                ntr: "Only Once",
            }
        },
        {
            name: "timeout",//q
            display: "Agent timeout",
            'default': 30,
        },
        {
            name: "retry",//q
            display: "Wait time for retry",
            'default': 15,
        },
        //Periodic Announce
        {
            name: "qu_info_periodic_announce",
            display: "Info",
            type: "info",
            value: "Periodic Announce",
        },
        {
            name: "periodic_announce", //q
            display: "Periodic Announce",
            options: "dynamic",
            type: "multipleSelect",
        },
        //Position/Time Announce
        {
            name: "qu_info_position",
            display: "Info",
            type: "info",
            value: "Position/Time Announce",
        },
        {
            name: "announce_frequency", //q
            display: "Announce Frequency",
        },
        {
            name: "announce_holdtime",//q
            display: "Announce holdtime",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "announce_round_seconds",//q
            display: "Announce Round Seconds",
            options: {
                "0": "No rounding",
                "60": "Only minutes",
                "1": "1",
                "5": "5",
            }
        },
        {
            name: "announce_position",//q
            display: "Announce position",
            options: {
                no: "Disabled",
                yes: "Enabled",
            }
        },
        {
            name: "qu_youarenext_me_id",
            display: '"You are the next" message',
            options: "dynamic"
        },
        {
            name: "qu_thereare_me_id",
            display: '"There are" message',
            options: "dynamic"
        },
        {
            name: "qu_callswaiting_me_id",
            display: '"Calls waiting" message',
            options: "dynamic"
        },
        {
            name: "qu_thankyou_me_id",
            display: '"Thank you" message',
            options: "dynamic"
        },
        {
            name: "qu_holdtime_me_id",
            display: '"The current est. holdtime is" message',
            options: "dynamic"
        },
    ],
    apiAccess: [
        {
            name: "se_id",
        },
        {
            name: "se_code",
        },
        {
            name: "se_value",
            display: "API Key",
            type: "password",
        }
    ],

    //port
    port: "dynamic",
//END editFormData=========================================================================       
};

var waitingFor = {};
var requestSend = {};
var cacheKeys = {
    "ph_line0_ex_id": "ph_lineX_ex_id",
    "ph_line1_ex_id": "ph_lineX_ex_id",
    "ph_line2_ex_id": "ph_lineX_ex_id",
    "ph_line3_ex_id": "ph_lineX_ex_id",
    "ph_line4_ex_id": "ph_lineX_ex_id",
    "ph_line5_ex_id": "ph_lineX_ex_id",

    "iv_ivr_1": "iv_ivr_X",
    "iv_ivr_2": "iv_ivr_X",
    "iv_ivr_3": "iv_ivr_X",
    "iv_ivr_4": "iv_ivr_X",
    "iv_ivr_5": "iv_ivr_X",
    "iv_ivr_6": "iv_ivr_X",
    "iv_ivr_7": "iv_ivr_X",
    "iv_ivr_8": "iv_ivr_X",
    "iv_ivr_9": "iv_ivr_X",
    "iv_ivr_0": "iv_ivr_X",
    "iv_ivr_star": "iv_ivr_X",
    "iv_ivr_sharp": "iv_ivr_X",

    qu_youarenext_me_id: "qu_media",
    qu_thereare_me_id: "qu_media",
    qu_callswaiting_me_id: "qu_media",
    qu_thankyou_me_id: "qu_media",
    qu_holdtime_me_id: "qu_media",
    periodic_announce: "qu_media_1",

};
var cache = {};

$(document).ready(function () {
    $('#giantModal').on('show.bs.modal', function (event) {

        var button = $(event.relatedTarget);

        if (!button.hasClass("tile")) {
            return;
        }

        var tileName = button.data('name');
        var title = button.html();
        var modal = $(this);
        modal.find("#giantModalTitle").html(title);
        modal.find("#giantModalDescription").html(modalDescriptions[tileName]);
        $('#giantModalAlertDiv').hide();
        refreshList(tileName);
    });
});

//refreshList===================================================================
function refreshList(tileName) {

    $('#giantModalListTableDiv').children().remove();
    $('#giantModalListTableDiv').append('<table id="giantModalList"><thead id="giantModalListHead"></thead><tbody id="giantModalListBody"></tbody></table>');
    $('.giantModalPanel').hide();
    $('#giantModalSpinnerDiv').show();
    $('#giantModalListDiv').find('#giantAddButton').remove();
    var action = "get" + capitalizeFirstLetter(tileName) + "List";

    $.ajax({
        type: 'post',
        data: {
            giantResellerAction: action,
        },
        success: function (responseJson) {

            var response = jQuery.parseJSON(responseJson);

            if (!response.fields) {
                $('#giantModalListHead').append('<tr><td>Not Available Yet</td></tr>');
                $('.giantModalPanel').hide();
                $('#giantModalListDiv').show();
                return;
            }

            $('.datepicker').parent().parent().remove();
            if (response.fromTo && response.asDataTable) {
                $('#giantModalAlertDiv').after('<div class="row"><div class="col-sm-6"><div class="form-group"><label class="col-form-label">From:</label><input type="text" id="from" class="datepicker form-control" value="' + response.from + '"></div></div><div class="col-sm-6"><div class="form-group"><label class="col-form-label">To:</label><input type="text" id="to" class="datepicker form-control" value="' + response.to + '"></div></div></div>');

                $('.datepicker').datepicker({
                    dateFormat: 'yy-mm-dd',
                    showOn: 'focus',
                });

                $('.datepicker').on("change", function (event) {
                    $.ajax({
                        type: 'post',
                        data: {
                            giantResellerAction: action,
                            from: $('#from').val(),
                            to: $('#to').val(),
                        },
                        success: function (responseJson) {
                            var response = jQuery.parseJSON(responseJson);
                            var rows = [];
                            if (response.data) {
                                Object.entries(response.data).forEach(function (data, index) {
                                    data = data[1];
                                    var row = [];
                                    Object.entries(response.fields).forEach(function (fieldData, index) {

                                        fieldData = fieldData[1];

                                        if (fieldData.asDownload) {
                                            if (data[fieldData.name]) {
                                                var formHtml = '<form method="post"><input type="hidden" name="giantResellerAction" value="' + fieldData.action + '"><input type="hidden" name="itemId" value="' + data[fieldData.name] + '"><button class="btn btn-primary">Download</button> </form>';
                                            } else {
                                                formHtml = "";
                                            }
                                            row.push(formHtml);
                                        } else {
                                            row.push(data[fieldData.name]);
                                        }
                                    });
                                    rows.push(row);
                                });
                            }
                            var datatable = $('#giantModalList').DataTable();
                            datatable.clear();
                            datatable.rows.add(rows);
                            datatable.draw();
                        }
                    });
                });
            }

            var tableHead = "<tr>";
            Object.entries(response.fields).forEach(function (fieldData, index) {
                fieldData = fieldData[1];
                tableHead += '<th>' + fieldData.display + '</th>';
            });
            if (!response.noActions) {
                tableHead += '<th>' + "Actions" + '</th>';
            }

            $('#giantModalListHead').append(tableHead);
            /*
            if(response.asDataTable) {
                $('#giantModalList').DataTable().clear().draw();
            }
            */
            if (response.data) {
                Object.entries(response.data).forEach(function (data, index) {
                    data = data[1];
                    var tableRow = "<tr>";
                    Object.entries(response.fields).forEach(function (fieldData, index) {
                        fieldData = fieldData[1];

                        if (data[fieldData.name]) {
                            if (fieldData.asButton) {

                                var copyButtonHtml = '<button class="giantCopyButton btn btn-primary" data-to-copy="' + data[fieldData.name] + '">Copy</button>';
                                tableRow += '<td>' + copyButtonHtml + '</td>'
                            } else if (fieldData.asQr) {

                                var qrButtonHtml = '<button class="giantQrButton btn btn-primary" data-qr-data="' + data[fieldData.name] + '">Show</button>';
                                tableRow += '<td>' + qrButtonHtml + '</td>'
                            } else if (fieldData.asDownload) {
                                if (data[fieldData.name]) {
                                    var formHtml = '<form method="post"><input type="hidden" name="giantResellerAction" value="' + fieldData.action + '"><input type="hidden" name="itemId" value="' + data[fieldData.name] + '"><button class="btn btn-primary">Download</button> </form>';

                                } else {
                                    formHtml = "";
                                }
                                tableRow += '<td>' + formHtml + '</td>';
                            } else {
                                tableRow += '<td>' + data[fieldData.name] + '</td>';
                            }
                        } else {
                            tableRow += '<td></td>';
                        }
                    });
                    if (response.idName) {
                        var editButton = '';
                        if (tileName == "port") {
                            if (editFormData[tileName]) {
                                if (data.status_code == "reject") {
                                    var editButton = '<button class="giantEditButton btn btn-primary"';
                                    editButton += ' data-ref=' + data.ref;
                                    editButton += ">Resubmit</button> ";
                                    //tableRow += '<td>' + editButton + '</td>';
                                }

                                let additionalDataButton = '<button class="giantAdditionalDataButton btn btn-primary"';
                                additionalDataButton += ' data-html=' + '"' + data.detailsHtml + '"';
                                additionalDataButton += ">Details</button> ";
                                tableRow += '<td style="text-align: right">' + editButton + additionalDataButton + '</td>';
                            }
                        } else {
                            if (editFormData[tileName]) {
                                var editButton = '<button class="giantEditButton btn btn-primary"';
                                Object.entries(data).forEach(function (entry, index) {

                                    var dataValue = entry[1];
                                    editButton += ' data-' + entry[0] + '=' + JSON.stringify(dataValue);
                                    +'';
                                });
                                editButton += ">Edit</button> ";
                            }
                            if (addFormData[tileName]) {
                                var removeForm = '<form class="giantModalRemoveForm" method="post">' + editButton + '<input type="hidden" name="giantResellerAction" value="' + "remove" + capitalizeFirstLetter(tileName) + '"><input type="hidden" name="' + response.idName + '" value="' + data[response.idName] + '"><input type="submit" class="btn btn-danger" value="Remove"></form>'
                                tableRow += '<td>' + removeForm + '</td>';
                            } else {
                                tableRow += '<td>' + editButton + '</td>';
                            }
                        }
                    }

                    tableRow += "</tr>";

                    $('#giantModalListBody').append(tableRow);
                });

                if (response.numberAddonUrl) {
                    $('#giantModalListDiv').append('<a id="giantAddButton" href="' + response.numberAddonUrl + '" class="btn btn-primary">Add New Numbers</a>');
                }
            }

            if (addFormData[tileName]) {
                if (tileName == "smsLog") {
                    $('#giantModalListDiv').append('<button id="giantAddButton" class="btn btn-primary">Send New SMS</button>');
                } else {
                    $('#giantModalListDiv').append('<button id="giantAddButton" class="btn btn-primary">Add</button>');
                }

                $('#giantAddButton').off('click');
                $('#giantAddButton').on('click', function (event) {
                    $('#giantModalAlertDiv').hide();
                    showForm(tileName, "add", addFormData[tileName], {});
                });
            }

            if (tileName == "apiAccess") {
                $('#giantModalListDiv').append('<a href="https://docs.api.giantcomms.co.uk/" target="_blank" id="giantAddButton" class="btn btn-primary">API Documentation</a>');
            }

            $('.giantCopyButton').off('click');
            $('.giantCopyButton').on('click', function (event) {
                event.preventDefault();

                var toCopy = $(this).data('to-copy');
                $(this).before("<input id='temp'>");
                var $temp = $("#temp");
                $temp.val(toCopy).select();
                document.execCommand("copy");
                $temp.remove();
            });

            $('.giantQrButton').off('click');
            $('.giantQrButton').on('click', function (event) {
                event.preventDefault();
                var qrData = $(this).data('qr-data');
                showQr(qrData);
            });

            $('.giantEditButton').off('click');
            $('.giantEditButton').on('click', function (event) {
                event.preventDefault();
                $('#giantModalAlertDiv').hide();
                showForm(tileName, "edit", editFormData[tileName], $(this).data());
            });

            $('.giantAdditionalDataButton').off('click');
            $('.giantAdditionalDataButton').on('click', function (event) {
                event.preventDefault();
                $('#giantModalAlertDiv').hide();
                showAdditionalData($(this).data("html"))
            });


            $('.giantModalRemoveForm').off('submit');
            $('.giantModalRemoveForm').on('submit', function (event) {

                event.preventDefault();

                if (!confirm('Are you sure?')) {
                    return;
                }
                $('#giantModalAlertDiv').hide();
                $('.giantModalPanel').hide();
                $('#giantModalSpinnerDiv').show();

                $.ajax({
                    type: 'post',
                    data: $(this).serialize(),
                    success: function (response) {
                        if (response.error) {
                            $('#giantModalAlertDiv').show();
                            $('#giantModalAlert').html(response.error);
                        }
                        refreshList(tileName);
                    }
                });
            });

            if (response.asDataTable) {
                $('#giantModalList').DataTable().draw();
            }

            $('.giantModalPanel').hide();
            $('#giantModalListDiv').show();
        }
    });
}

function showForm(tileName, type, formData, defaultValues) {

    var form = $("#giantModalAddForm");

    form.children().remove();

    cache = {};
    requestSend = {};

    if (!formData) {
        return;
    }

    $('.giantModalPanel').hide();
    $('#giantModalSpinnerDiv').show();

    if (formData == "dynamic") {
        $.ajax({
            type: 'post',
            data: {
                giantResellerAction: "getForm",
                formName: tileName,
                formType: type,
                defaultValues: defaultValues,
            },
            success: function (responseJson) {
                var response = jQuery.parseJSON(responseJson);
                $("#giantModalAddForm").replaceWith(response.formHtml);
                $('.giantModalPanel').hide();
                $('#giantModalAddFormDiv').show();
            }
        });
        return;
    }

    var toTrigger = [];

    formData.forEach(function (fieldData) {

        var defaultValue = defaultValues[fieldData.name];

        if (!defaultValue) {
            defaultValue = '';
        }

        if (fieldData.display) {

            var label = '<label class="col-form-label">' + fieldData.display + ':</label>';
            var description = "";

            if (fieldData.description) {
                description = '<small class="form-text text-muted">' + fieldData.description + '</small>';
            }
            if (fieldData.type == "signature") {

                var elementHtml = '<div id="signature" style="width: 600px; height:200px; border-style: solid; border-width: 1px"></div> <br><br>';
                elementHtml += '<button id="clear">Clear Signature</button>';
                elementHtml += '<textarea id="sigpad" name="signature" style="display: none"></textarea>';

                form.append('<div class="form-group">' + label + elementHtml + description + '</div>');
                var signature = $('#signature').signature({syncField: '#sigpad', syncFormat: 'PNG'});
                $('#clear').click(function (e) {
                    e.preventDefault();
                    signature.signature('clear');
                    $("#sigpad").val('');
                });

            } else if (fieldData.type == "info") {

                var elementHtml = '<div id = "' + fieldData.name + 'Info" class="alert alert-primary" role="alert" name="' + fieldData.name + '">test</div>';

                form.append(elementHtml);

                if (fieldData.value == "dynamic") {
                    addDynamicText($('#' + fieldData.name + 'Info'));
                } else {
                    addText($('#' + fieldData.name + 'Info'), fieldData.value);
                }

            } else if (fieldData.type == "checkbox") {

                var fieldGroup = '<div id="' + fieldData.name + 'Group">' + fieldData.display + ':</br></div>';
                form.append(fieldGroup);
                if (fieldData.options) {
                    if (fieldData.options == "dynamic") {

                        waitingFor[fieldData.name] = true;

                        $.ajax({
                            type: 'post',
                            data: {
                                giantResellerAction: "getOptions",
                                fieldName: fieldData.name,
                            },
                            success: function (responseJson) {
                                var response = jQuery.parseJSON(responseJson)
                                Object.entries(response.options).forEach(function (data, index) {
                                    var optionDisplay = data[1];
                                    var optionValue = data[0];
                                    var checked = "";

                                    if (jQuery.inArray(optionValue, defaultValue) !== -1) {
                                        checked = "checked";
                                    }

                                    var fieldHtml = '';
                                    fieldHtml += '<div class="form-check">'
                                    fieldHtml += '<input type="checkbox" id="' + optionValue + 'Checkbox" name="' + fieldData.name + '[]" value="' + optionValue + '" ' + checked + '>';
                                    fieldHtml += '<label class="form-check-label" for="' + optionValue + 'Checkbox"> ' + optionDisplay + '</label>';
                                    fieldHtml += '</div>';

                                    //field = '<label><input type="checkbox" id="" name="' + fieldData.name + '[]" value="' + optionValue + '" '+ checked +'>' + optionDisplay + '</label></br>';

                                    $('#' + fieldData.name + 'Group').append(fieldHtml);
                                });
                                waitingFor[fieldData.name] = false;
                            }
                        });
                    }
                }

            } else if (fieldData.type == "multipleSelect") {

                var fieldHtml = '<select class="form-control" id="' + fieldData.name + 'Input" name="' + fieldData.name + '[]"></select>';
                form.append('<div class="form-group">' + label + fieldHtml + description + '</div>');

                if (defaultValue) {
                    var defaultValueItem = defaultValue[0];
                }

                if (fieldData.options == "dynamic") {
                    addDynamicOptions($('[name="' + fieldData.name + '[]"]').last(), defaultValueItem);
                } else {
                    addOptions($('[name="' + fieldData.name + '[]"]').last(), fieldData.options, defaultValueItem);
                }

                var removeButtonHtml = '<button class="' + fieldData.name + 'RemoveButton removeSelectButton btn btn-sm btn-danger">-</button>';
                if (defaultValue) {
                    defaultValue.forEach(function (defaultValueItem, index) {

                        if (index > 0) {
                            fieldHtml = '<select class="form-control secondarySelect ' + fieldData.name + 'Input" name="' + fieldData.name + '[]"></select>';
                            $('[name="' + fieldData.name + '[]"]').last().parent().after('<div class="form-group">' + fieldHtml + ' ' + removeButtonHtml + '</div>');

                            if (fieldData.options == "dynamic") {
                                addDynamicOptions($('[name="' + fieldData.name + '[]"]').last(), defaultValueItem);
                            } else {
                                addOptions($('[name="' + fieldData.name + '[]"]').last(), fieldData.options, defaultValueItem);
                            }
                        }
                    });
                }
                $('.' + fieldData.name + 'RemoveButton').off("click");
                $('.' + fieldData.name + 'RemoveButton').on("click", function (event) {
                    event.preventDefault();
                    $(this).parent().remove();
                });

                var addbuttonHtml = '<button id= "' + fieldData.name + 'AddButton" class="btn btn-sm btn-primary">+</button>';
                $('[name="' + fieldData.name + '[]"]').last().parent().after('<div class="form-group">' + addbuttonHtml + '</div>');

                $('#' + fieldData.name + 'AddButton').off("click");
                $('#' + fieldData.name + 'AddButton').on("click", function (event) {
                    event.preventDefault();
                    fieldHtml = '<select class="form-control secondarySelect ' + fieldData.name + 'Input" name="' + fieldData.name + '[]"></select>';
                    $(this).parent().before('<div class="form-group">' + fieldHtml + ' ' + removeButtonHtml + '</div>');

                    $('.' + fieldData.name + 'RemoveButton').off("click");
                    $('.' + fieldData.name + 'RemoveButton').on("click", function (event) {
                        event.preventDefault();
                        $(this).parent().remove();
                    });

                    var options = $('#' + fieldData.name + 'Input > option').clone().removeAttr('selected');
                    $('[name="' + fieldData.name + '[]"]').last().append(options);

                });

            } else if (fieldData.type == "password") {

                var fieldHtml = '<div class="input-group mb-3">';
                fieldHtml += '<input type="text" class="form-control" id="' + fieldData.name + 'Input" name="' + fieldData.name + '" value="' + defaultValue + '">'
                fieldHtml += '<div class="input-group-append"><button id="' + fieldData.name + 'Button" class="btn btn-primary" type="button">Generate</button></div>';
                fieldHtml += '</div>';

                form.append('<div class="form-group">' + label + fieldHtml + description + '</div>');

                $('#' + fieldData.name + 'Button').off("click");
                $('#' + fieldData.name + 'Button').on("click", function (event) {
                    $('#' + fieldData.name + 'Input').val(generatePassword(16));
                });
            } else if (fieldData.options) { //select

                var fieldHtml = '<select class="form-control" id="' + fieldData.name + 'Input" name="' + fieldData.name + '"></select>';
                form.append('<div class="form-group">' + label + fieldHtml + description + '</div>');

                if (fieldData.options == "dynamic") {
                    addDynamicOptions($('#' + fieldData.name + 'Input'), defaultValue);
                } else {
                    addOptions($('#' + fieldData.name + 'Input'), fieldData.options, defaultValue);
                }
            } else if (fieldData.type == "textarea") {
                var fieldHtml = '<textarea rows="4" cols="50"  class="form-control" id="' + fieldData.name + 'Input" name="' + fieldData.name + '" value="' + defaultValue + '"></textarea>'
                form.append('<div class="form-group">' + label + fieldHtml + description + '</div>');
            } else {//text
                var fieldHtml = '<input type="text" class="form-control" id="' + fieldData.name + 'Input" name="' + fieldData.name + '" value="' + defaultValue + '">'
                form.append('<div class="form-group">' + label + fieldHtml + description + '</div>');
            }
        } else {//hidden

            var fieldHtml = '<input type="hidden" class="form-control" id="' + fieldData.name + 'Input" name="' + fieldData.name + '" value="' + defaultValue + '">'
            form.append('<div class="form-group">' + fieldHtml + '</div>');
        }

        if (fieldData.mask) {
            $('[name="' + fieldData.name + '"]').inputmask(fieldData.mask);
        }
        if (fieldData.onChange) {
            $('[name="' + fieldData.name + '"]').off("change");
            $('[name="' + fieldData.name + '"]').on("change", fieldData.onChange);

            toTrigger.push(fieldData.name);
        }

    });

    var buttonDisplay = "Add";

    if (type == "edit") {
        buttonDisplay = "Save";
    }

    if (type == "add" && tileName == "smsLog") {
        buttonDisplay = "Send";
    }


    var action = type + capitalizeFirstLetter(tileName);
    form.append('<input type="hidden" name="giantResellerAction" value="' + action + '">');
    form.append('<input type="submit" class="btn btn-primary" value="' + buttonDisplay + '">');
    form.append(' <button id="giantCancelAddButton" class="btn btn-secondary">Cancel</button>');

    $('#giantCancelAddButton').off('click');
    $('#giantCancelAddButton').on('click', function (event) {
        event.preventDefault();
        $('#giantModalListDiv').show();
        $('#giantModalAddFormDiv').hide();
    });

    $('#giantModalAddForm').off('submit');
    $('#giantModalAddForm').on('submit', function (event) {

        $('.giantModalPanel').hide();
        $('#giantModalSpinnerDiv').show();

        event.preventDefault();
        $.ajax({
            type: 'post',
            data: $(this).serialize(),
            success: function (responseJson) {
                var response = jQuery.parseJSON(responseJson);

                if (response && response.error) {
                    $('#giantModalAlertDiv').show();
                    $('#giantModalAlert').html(response.error);
                }
                refreshList(tileName);
            }
        });
    });
    var waitingEditInterval = setInterval(() => {
        var waiting = false;
        Object.entries(waitingFor).forEach(function (data, index) {
            if (data[1] == true) {
                waiting = true;
                return
            }
        });
        if (!waiting) {
            clearInterval(waitingEditInterval);
            toTrigger.forEach(function (fieldName) {

                $('[name="' + fieldName + '"]').trigger("change");

            });

            $('.giantModalPanel').hide();
            $('#giantModalAddFormDiv').show();


            return;
        }
    }, 500);
}

function showAdditionalData(dataHtml) {
    $('.giantModalPanel').hide();
    $('#giantModalAdditionalDataDiv').show();
    $('#giantModalAdditionalDataDiv').children().remove();
    $('#giantModalAdditionalDataDiv').append(dataHtml);
    $('#giantModalAdditionalDataDiv').append('</br></br><button class="btn btn-secondary giantBackButton">Back</button>');

    $('.giantBackButton').off('click');
    $('.giantBackButton').on('click', function (event) {
        event.preventDefault();
        $('.giantModalPanel').hide();
        $('#giantModalListDiv').show();
    });
}



function addOptions(selectInput, options, defaultValue = '', additionalData = []) {

    if (!options) {
        return;
    }

    Object.entries(options).forEach(function (optionData, index) {
        var selected = '';
        var optionDisplay = optionData[1];
        var optionValue = optionData[0];
        if (optionValue == defaultValue) {
            selected = 'selected';
        }
        var additionalDataHtml = '';
        if (additionalData[optionValue]) {

            Object.entries(additionalData[optionValue]).forEach(function (entry, index) {

                additionalDataHtml += 'data-' + entry[0] + '=' + '"' + entry[1] + '" ';

            });
        }

        selectInput.append('<option value="' + optionValue + '"' + selected + " " + additionalDataHtml + '>' + optionDisplay + '</option>');
    });
}

function addDynamicOptions(selectInput, defaultValue = '') {

    var fieldName = selectInput.attr('name').replace('[]', '');
    var fieldToken = fieldName + Math.floor(Math.random() * 10000);
    waitingFor[fieldToken] = true;

    var cacheKey = fieldName;
    if (cacheKeys[fieldName]) {
        cacheKey = cacheKeys[fieldName];
    }

    if (requestSend[cacheKey]) {

        var waitingForCacheInterval = setInterval(() => {
            if (cache[cacheKey]) {
                addOptions(selectInput, cache[cacheKey]["options"], defaultValue, cache[cacheKey]["data"]);
                clearInterval(waitingForCacheInterval);
                waitingFor[fieldToken] = false;
            }
        }, 500);

    } else {

        requestSend[cacheKey] = true;
        $.ajax({
            type: 'post',
            data: {
                giantResellerAction: "getOptions",
                fieldName: fieldName,
            },
            success: function (responseJson) {
                var response = jQuery.parseJSON(responseJson);
                var additionalData = [];
                if (response.data) {
                    additionalData = response.data;
                }

                cache[cacheKey] = {options: response.options, data: additionalData}
                addOptions(selectInput, response.options, defaultValue, additionalData);
                waitingFor[fieldToken] = false;
            }
        });
    }
}

function addText(element, text) {
    element.html(text);
}

function addDynamicText(element) {

    var elementName = element.attr('name').replace('[]', '');
    var elementToken = elementName + Math.floor(Math.random() * 10000);
    waitingFor[elementToken] = true;

    $.ajax({
        type: 'post',
        data: {
            giantResellerAction: "getText",
            elementName: elementName,
        },
        success: function (responseJson) {
            var response = jQuery.parseJSON(responseJson);
            addText(element, response.text);
            waitingFor[elementToken] = false;
        }
    });
}

function setupRomoveForms() {

    $('.removeForm').off('submit');
    $('.removeForm').on('submit', function (event) {
        event.preventDefault();
        $.ajax({
            type: 'post',
            data: $(this).serialize(),
            success: function (response) {
                if (response.error) {
                    $('#giantModalAlertDiv').show();
                    $('#giantModalAlert').html(response.error);
                } else {
                    $(event.relatedTarget).parent().parent().remove();
                }
            }
        });
    });
}

function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}

function generatePassword(length) {
    var result = '';
    var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;

    for (var i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}