$(document).ready(function () {
    // Validate authentication
    $('.validate-button').on('click', function () {
        this.name = '.validate';

        // Show in progress
        $(this.name).hide();
        $(this.name + '.text-progress').show();

        // Post validation data
        $.post('../modules/addons/supportpal/validate.php',
            {
                validate_token: $('input[name="validate_token"]').val(),
                base_url: $('input[name="base_url"]').val(),
                api_token: $('input[name="api_token"]').val(),
                brand_id: $('input[name="brand_id"]').val()
            }, handleSuccessfulResponse.bind(this), 'json')
            .fail(handleUnsuccessfulResponse);
    });

    // Handle toggling self-service enabled checkbox.
    $('input[name="announcements_enabled"], input[name="knowledgebase_enabled"], input[name="downloads_enabled"]').on('click', function () {
        $(this).parent('div').next().toggle();
    })

    // Validate self service types
    $('.validate-types-button').on('click', function () {
        this.name = '.validate_types';

        // Show in progress
        $(this.name).hide();
        $(this.name + '.text-progress').show();

        // Post validation data
        $.post('../modules/addons/supportpal/validate.php',
            {
                validate_token: $('input[name="validate_token"]').val(),
                base_url: $('input[name="base_url"]').val(),
                api_token: $('input[name="api_token"]').val(),
                brand_id: $('input[name="brand_id"]').val(),
                announcements_id: $('input[name="announcements_enabled"]').prop('checked') ?
                    $('input[name="announcements_id"]').val() : null,
                knowledgebase_id: $('input[name="knowledgebase_enabled"]').prop('checked') ?
                    $('input[name="knowledgebase_id"]').val() : null,
                downloads_id: $('input[name="downloads_enabled"]').prop('checked') ?
                    $('input[name="downloads_id"]').val() : null
            }, handleSuccessfulResponse.bind(this), 'json')
            .fail(handleUnsuccessfulResponse.bind(this));
    });

    function handleSuccessfulResponse(response) {
        var cssClassName = this.name;

        if (response.status == 'success') {
            $(cssClassName + '.text-progress').hide();
            $(cssClassName + '.text-success').show();
        } else {
            $(cssClassName + '.text-progress').hide();
            if (/<[a-z][\s\S]*>/i.test(response.message)) {
                $(cssClassName + ' .error-message').text($(response.message).text());
            } else {
                $(cssClassName + ' .error-message').text(response.message);
            }
            $(cssClassName + '.text-fail').show();
        }
    }

    function handleUnsuccessfulResponse() {
        var cssClassName = this.name;

        $(cssClassName + '.text-progress').hide();
        $(cssClassName + ' .error-message').text('');
        $(cssClassName + '.text-fail').show();
    }
});
