<?php

declare (strict_types=1);

use SupportPal\WhmcsIntegration\DI\Container;
use SupportPal\WhmcsIntegration\HooksEncapsulator;
use WHMCS\Application\Support\Facades\App;
use WHMCS\Application\Support\Facades\Lang;
use WHMCS\Language\ClientLanguage;
// Do not load hooks if the module is not enabled.
if (\strtolower(\trim($GLOBALS['CONFIG']['SupportModule'])) !== 'supportpal') {
    return;
}
require_once __DIR__ . '/../../support/supportpal/Bootstrap/autoload.php';
/** @var HooksEncapsulator $instance */
$instance = \SupportPal\WhmcsIntegration\DI\Container::getDefaultContainer()->get(\SupportPal\WhmcsIntegration\HooksEncapsulator::class);
// Register WHMCS hook listeners.
// See https://developers.whmcs.com/hooks/hook-index/
foreach ($instance->getHooks() as $hook => $methods) {
    foreach ($methods as $priority => $method) {
        \add_hook($hook, $priority + 1, [$instance, $method]);
    }
}
// Register WHMCS model event listeners.
// See https://classdocs.whmcs.com/8.0/index.html
foreach ($instance->getModelEvents() as $model => $events) {
    foreach ($events as $event => $listeners) {
        foreach ($listeners as $listener) {
            $model::$event([$instance, $listener]);
        }
    }
}
/**
 * Redirect /announcements to announcements.php
 */
\add_hook('ClientAreaPageAnnouncements', 1, function ($vars) {
    /** @var HooksEncapsulator $instance */
    $instance = \SupportPal\WhmcsIntegration\DI\Container::getDefaultContainer()->get(\SupportPal\WhmcsIntegration\HooksEncapsulator::class);
    $instance->redirectToSupportPalPage(\WHMCS\Application\Support\Facades\App::getInstance(), 'announcements');
});
/**
 * Redirect /knowledgebase to knowledgebase.php
 */
\add_hook('ClientAreaPageKnowledgebase', 1, function ($vars) {
    /** @var HooksEncapsulator $instance */
    $instance = \SupportPal\WhmcsIntegration\DI\Container::getDefaultContainer()->get(\SupportPal\WhmcsIntegration\HooksEncapsulator::class);
    $instance->redirectToSupportPalPage(\WHMCS\Application\Support\Facades\App::getInstance(), 'knowledgebase');
});
/**
 * Redirect /downloads to downloads.php
 */
\add_hook('ClientAreaPageDownloads', 1, function ($vars) {
    /** @var HooksEncapsulator $instance */
    $instance = \SupportPal\WhmcsIntegration\DI\Container::getDefaultContainer()->get(\SupportPal\WhmcsIntegration\HooksEncapsulator::class);
    $instance->redirectToSupportPalPage(\WHMCS\Application\Support\Facades\App::getInstance(), 'downloads');
});
/**
 * Load our support module pages instead of WHMCS, only needed for self-service sections currently.
 * Note that this needs to be at the end of the file so it registers the hooks first as they may run in these views.
 */
foreach (['announcements', 'knowledgebase', 'downloads'] as $section) {
    if (\WHMCS\Application\Support\Facades\App::getCurrentFilename() !== $section) {
        continue;
    }
    $supportmodulepath = 'modules/support/' . $GLOBALS['CONFIG']['SupportModule'] . '/' . $section . '.php';
    if (!\file_exists($supportmodulepath)) {
        continue;
    }
    // Handle language changing, for some reason doesn't work automatically for these pages.
    if (isset($_REQUEST['language'])) {
        $language = \WHMCS\Language\ClientLanguage::factory('', '', $_REQUEST['language'], \true);
        \WHMCS\Application\Support\Facades\Lang::swap($language);
    }
    require $supportmodulepath;
    \outputClientArea('');
    exit;
}
