<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Bootstrap;

use function file_exists;
use function getenv;
use function is_string;
use function realpath;
use const DIRECTORY_SEPARATOR;
// Register our autoloader.
require_once __DIR__ . '/autoload.php';
// Bootstrap WHMCS.
$directory = \getenv('WHMCS_PATH');
$path = \is_string($directory) ? \realpath($directory . \DIRECTORY_SEPARATOR . 'init.php') : \false;
if ($path !== \false && \file_exists($path)) {
    require_once $path;
} else {
    // Fallback to init.php in the base directory.
    require_once __DIR__ . '/../../../../init.php';
}
