<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Controller\SelfService;

use Closure;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\Factory\ResponseFactory;
use SupportPal\WhmcsIntegration\Repository\SelfService\ArticleRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\ArticleTypeRepository;
use SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Service\Converter\ModelToArrayConverter;
class RelatedArticlesController
{
    private const ERROR_MESSAGE = 'No knowledgebase type available.';
    /** @var ModSupportPalRepository */
    private $modSupportPalRepository;
    /** @var ArticleTypeRepository */
    private $articleTypeRepository;
    /** @var ModelToArrayConverter */
    private $modelToArrayConverter;
    /** @var ArticleRepository */
    private $articleRepository;
    /** @var ResponseFactory */
    private $responseFactory;
    public function __construct(\SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository $modSupportPalRepository, \SupportPal\WhmcsIntegration\Repository\SelfService\ArticleTypeRepository $articleTypeRepository, \SupportPal\WhmcsIntegration\Service\Converter\ModelToArrayConverter $modelToArrayConverter, \SupportPal\WhmcsIntegration\Repository\SelfService\ArticleRepository $articleRepository, \SupportPal\WhmcsIntegration\Factory\ResponseFactory $responseFactory)
    {
        $this->modSupportPalRepository = $modSupportPalRepository;
        $this->articleTypeRepository = $articleTypeRepository;
        $this->modelToArrayConverter = $modelToArrayConverter;
        $this->articleRepository = $articleRepository;
        $this->responseFactory = $responseFactory;
    }
    public function index(\SupportPal\WhmcsIntegration\Request\Request $request) : void
    {
        $term = $request->get('term', null);
        if ($term === null) {
            $this->responseFactory->createJsonResponse($this->getErrorArray(self::ERROR_MESSAGE))->send();
            return;
        }
        try {
            $typeId = $this->getTypeId();
        } catch (\SupportPal\WhmcsIntegration\Exception\InvalidApiResponse $e) {
            $this->responseFactory->createJsonResponse($this->getErrorArray($e->getMessage()))->send();
            return;
        }
        if ($typeId === null) {
            $this->responseFactory->createJsonResponse($this->getErrorArray(self::ERROR_MESSAGE))->send();
            return;
        }
        $data = ['protected' => 1];
        try {
            $relatedArticles = $this->articleRepository->findRelatedBy($typeId, $term, $data);
        } catch (\SupportPal\WhmcsIntegration\Exception\InvalidApiResponse $e) {
            $this->responseFactory->createJsonResponse($this->getErrorArray($e->getMessage()))->send();
            return;
        }
        $models = $this->modelToArrayConverter->convertManyAndApply($relatedArticles->getModels(), $this->parseArticle());
        $this->responseFactory->createJsonResponse(['status' => 'success', 'count' => $relatedArticles->getCount(), 'data' => $models])->send();
    }
    /**
     * @return Closure
     */
    private function parseArticle() : \Closure
    {
        return function (array $article) {
            return ['id' => $article['id'], 'slug' => $article['slug'], 'title' => $article['title'], 'excerpt' => $article['excerpt']];
        };
    }
    /**
     * @param string $message
     * @return string[]
     */
    private function getErrorArray(string $message) : array
    {
        return ['status' => 'error', 'message' => $message];
    }
    /** @throws InvalidApiResponse */
    private function getTypeId() : ?int
    {
        $typeId = $this->modSupportPalRepository->getInt('knowledgebase_id');
        if ($typeId !== null) {
            return $typeId;
        }
        $type = $this->articleTypeRepository->findOneByName(\SupportPal\WhmcsIntegration\Controller\SelfService\KnowledgeBaseController::TYPE);
        return $type !== null ? $type->getId() : null;
    }
}
