<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Controller\Ticket;

use Closure;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings;
use SupportPal\WhmcsIntegration\Helper\DateTimeFormatter;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\File\UploadedFile;
use function array_map;
use function base64_encode;
use function file_get_contents;
class BaseTicketController
{
    /** @var DateTimeFormatter */
    protected $dateTimeFormatter;
    public function __construct(\SupportPal\WhmcsIntegration\Helper\DateTimeFormatter $dateTimeFormatter)
    {
        $this->dateTimeFormatter = $dateTimeFormatter;
    }
    /**
     * @param Settings $settings
     * @return Closure
     */
    protected function formatDateTime(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings $settings) : \Closure
    {
        return function (array $ticket) use($settings) {
            $ticket['created_at'] = $this->dateTimeFormatter->format((string) $settings->get('date_format', 'd/m/Y'), (string) $settings->get('time_format', 'g:i A'), $ticket['created_at']);
            $ticket['updated_at'] = $this->dateTimeFormatter->format((string) $settings->get('date_format', 'd/m/Y'), (string) $settings->get('time_format', 'g:i A'), $ticket['updated_at']);
            return $ticket;
        };
    }
    /**
     * @param Request $request
     * @param mixed[] $data
     * @return mixed[]
     */
    protected function parseAttachments(\SupportPal\WhmcsIntegration\Request\Request $request, array $data) : array
    {
        $attachments = $request->getFiles()->get('attachments', null);
        if ($attachments !== null) {
            $data['attachment'] = \array_map(function (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\File\UploadedFile $attachment) {
                return ['filename' => $attachment->getClientOriginalName(), 'contents' => \base64_encode((string) \file_get_contents($attachment->getPathname()))];
            }, $attachments);
        }
        return $data;
    }
}
