<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Factory;

use Illuminate\Support\Str;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\HeaderUtils;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\JsonResponse;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\RedirectResponse;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Response;
use function str_replace;
class ResponseFactory
{
    /**
     * @param string $redirectUrl
     * @return RedirectResponse
     */
    public function createRedirectResponse(string $redirectUrl) : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\RedirectResponse
    {
        return new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\RedirectResponse($redirectUrl);
    }
    /**
     * @param array<mixed> $body
     * @return JsonResponse
     */
    public function createJsonResponse(array $body) : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\JsonResponse
    {
        return new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\JsonResponse($body);
    }
    /**
     * @param StreamInterface $stream
     * @param string $fileName
     * @return Response
     */
    public function createDownloadResponse(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface $stream, string $fileName) : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Response
    {
        $response = new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Response($stream->getContents());
        $response->headers->set('Content-Description', 'File Transfer');
        $response->headers->set('Content-Type', 'application/octet-stream');
        $response->headers->set('Content-Disposition', $this->makeDisposition($fileName));
        $response->headers->set('Content-Transfer-Encoding', 'binary');
        $response->headers->set('Expires', '0');
        $response->headers->set('Cache-Control', 'must-revalidate');
        $response->headers->set('Pragma', 'public');
        $response->headers->set('Content-Length', (string) $stream->getSize());
        return $response;
    }
    private function makeDisposition(string $name, string $disposition = \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\HeaderUtils::DISPOSITION_ATTACHMENT) : string
    {
        // Strip slashes from name
        $name = \str_replace(['\\', '/'], '', $name);
        // Strip % from fallback name and convert it to ascii only
        $fallbackName = \str_replace('%', '', \Illuminate\Support\Str::ascii($name));
        return \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\HeaderUtils::makeDisposition($disposition, $name, $fallbackName);
    }
}
