<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

use SupportPal\WhmcsIntegration\Factory\CurrentUserFactory;
use WHMCS\User\Client;
use WHMCS\User\User;
use function explode;
use function in_array;
class AuthenticatedUserHelper
{
    /** @var SessionHelper */
    private $sessionHelper;
    /** @var CurrentUserFactory */
    private $currentUserFactory;
    public function __construct(\SupportPal\WhmcsIntegration\Helper\SessionHelper $sessionHelper, \SupportPal\WhmcsIntegration\Factory\CurrentUserFactory $currentUserFactory)
    {
        $this->sessionHelper = $sessionHelper;
        $this->currentUserFactory = $currentUserFactory;
    }
    /**
     * Get authenticated user.
     *
     * @return User|null
     */
    public function getAuthenticatedUser() : ?\WHMCS\User\User
    {
        if ($this->sessionHelper->get('uid', null) !== null) {
            return $this->currentUserFactory->create()->user();
        }
        return null;
    }
    /**
     * Get authenticated client (parent of user).
     *
     * @return Client|null
     */
    public function getAuthenticatedClient() : ?\WHMCS\User\Client
    {
        if ($this->sessionHelper->get('uid', null) !== null) {
            return $this->currentUserFactory->create()->client();
        }
        return null;
    }
    /**
     * Check if authenticated user has the tickets permission.
     *
     * @return bool
     */
    public function hasTicketsPermission() : bool
    {
        /** Must be logged in. */
        $uid = $this->sessionHelper->get('uid');
        if ($uid === null) {
            return \false;
        }
        /** Get client account - need to get this as you can't tell it's a user or client without this model. */
        $client = $this->currentUserFactory->create()->client();
        if ($client === null) {
            return \false;
        }
        /** Are they the main client? */
        if ((int) $client->pivot->owner === 1) {
            return \true;
        }
        $permissions = \explode(',', $client->pivot->permissions ?? '');
        /** Check if they have the tickets permission. */
        return \in_array('tickets', $permissions);
    }
}
