<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Log;

use Exception;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface;
use function sprintf;
class ExceptionLogger
{
    private const MODULE_NAME = 'mod_supportpal';
    /** @var LogModuleWrapper */
    private $logModuleWrapper;
    /** @var EncoderInterface */
    private $encoder;
    public function __construct(\SupportPal\WhmcsIntegration\Log\LogModuleWrapper $logModuleWrapper, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface $encoder)
    {
        $this->logModuleWrapper = $logModuleWrapper;
        $this->encoder = $encoder;
    }
    /**
     * @param Exception $exception
     * @param string $action
     * @param array<mixed> $data
     */
    public function log(\Exception $exception, string $action, array $data = []) : void
    {
        $this->logModuleWrapper->log(self::MODULE_NAME, \sprintf('Action: %s - Exception Message: %s', $action, $exception->getMessage()), $this->encoder->encode($this->request(), 'json'), $this->encoder->encode($data, 'json'));
    }
    /**
     * @return string[]
     */
    private function request() : array
    {
        $request = \SupportPal\WhmcsIntegration\Request\Request::createFromGlobals();
        return ['method' => $request->getMethod(), 'uri' => $request->getRequestUri(), 'body' => $request->getContent()];
    }
}
