<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Log;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface;
use function html_entity_decode;
class RequestLogFormatter
{
    /** @var EncoderInterface */
    private $encoder;
    /** @var bool */
    private $withGlobals = \false;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\EncoderInterface $encoder)
    {
        $this->encoder = $encoder;
    }
    public function withGlobals() : self
    {
        $this->withGlobals = \true;
        return $this;
    }
    public function withoutGlobals() : self
    {
        $this->withGlobals = \false;
        return $this;
    }
    public function format(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request) : string
    {
        $data = ['method' => $request->getMethod(), 'uri' => (string) $request->getUri(), 'headers' => $request->getHeaders(), 'body' => (string) $request->getBody()];
        if ($this->withGlobals) {
            $data['globals'] = $this->globals();
        }
        return $this->encoder->encode($data, 'json');
    }
    /**
     * @return string[]
     */
    private function globals() : array
    {
        $request = \SupportPal\WhmcsIntegration\Request\Request::createFromGlobals();
        return ['method' => $request->getMethod(), 'uri' => \html_entity_decode($request->getRequestUri()), 'body' => $request->getContent()];
    }
}
