<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Core;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\CoreApi;
use SupportPal\WhmcsIntegration\Repository\BaseRepository;
/**
 * Class BaseCoreRepository
 * @package SupportPal\WhmcsIntegration\Repository\Core
 */
abstract class BaseCoreRepository extends \SupportPal\WhmcsIntegration\Repository\BaseRepository
{
    /**
     * @return CoreApi
     * @throws Exception
     */
    protected function getApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\CoreApi
    {
        return $this->getApiClientWrapper()->getSupportPal()->getCoreApi();
    }
}
