<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Core;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class CoreSettingsRepository
 * @package SupportPal\WhmcsIntegration\Repository
 */
class CoreSettingsRepository extends \SupportPal\WhmcsIntegration\Repository\Core\BaseCoreRepository
{
    /**
     * Get the core settings, mainly for the date and time format
     *
     * @return Settings
     * @throws InvalidApiResponse
     */
    public function get() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings
    {
        return $this->callAndMapException(function () {
            return $this->getApi()->getSettings();
        }, 'getSettings');
    }
}
