<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\SelfService;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Article;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class ArticleRepository
 * @package SupportPal\WhmcsIntegration\Repository\SelfService
 */
class ArticleRepository extends \SupportPal\WhmcsIntegration\Repository\SelfService\BaseSelfServiceRepository
{
    /**
     * @param int $id
     * @param mixed[] $data
     * @return Article
     * @throws InvalidApiResponse
     */
    public function find(int $id, array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Article
    {
        return $this->callAndMapException(function () use($id, $data) {
            return $this->getApi()->getArticle($id, $data);
        }, 'getArticle');
    }
    /**
     * @param string $term
     * @param mixed[] $data
     * @return Collection
     * @throws Exception
     */
    public function findByTerm(string $term, array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($term, $data) {
            return $this->getApi()->getArticlesByTerm($term, $data);
        }, 'getArticlesByTerm');
    }
    /**
     * @param int $typeId
     * @param string $term
     * @param mixed[] $data
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findRelatedBy(int $typeId, string $term, array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($typeId, $term, $data) {
            return $this->getApi()->getRelatedArticles($typeId, $term, $data);
        }, 'getRelatedArticles');
    }
    /**
     * @param int $typeId
     * @param int $categoryId
     * @param mixed[] $parameters
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findByTypeAndCategory(int $typeId, int $categoryId, array $parameters) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $parameters['type_id'] = $typeId;
        $parameters['category_id'] = $categoryId;
        return $this->findBy($parameters);
    }
    /**
     * @param mixed[] $data
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findBy(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($data) {
            return $this->getApi()->getArticles($data);
        }, 'getArticles');
    }
}
