<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class ArticleTypeRepository
 * @package SupportPal\WhmcsIntegration\Repository
 */
class ArticleTypeRepository extends \SupportPal\WhmcsIntegration\Repository\SelfService\BaseSelfServiceRepository
{
    /**
     * @param array<mixed> $filters
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findBy(array $filters) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($filters) {
            return $this->getApi()->getTypes($filters);
        }, 'getTypes');
    }
    /**
     * @param string $name
     * @param array<mixed> $filters
     * @return Type|null
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function findOneByName(string $name, array $filters = []) : ?\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type
    {
        $articleTypesCollection = $this->findBy($filters);
        /** @var Type $type */
        $type = $articleTypesCollection->filter(function (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type $type) use($name) {
            return $type->getSlug() === $name;
        })->first();
        return $type;
    }
}
