<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\SelfService;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfServiceApi;
use SupportPal\WhmcsIntegration\Repository\BaseRepository;
/**
 * Class BaseSelfServiceRepository
 * @package SupportPal\WhmcsIntegration\Repository\SelfService
 */
abstract class BaseSelfServiceRepository extends \SupportPal\WhmcsIntegration\Repository\BaseRepository
{
    /**
     * @return SelfServiceApi
     * @throws Exception
     */
    protected function getApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfServiceApi
    {
        return $this->getApiClientWrapper()->getSupportPal()->getSelfServiceApi();
    }
}
