<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
class SelfServiceSettingsRepository extends \SupportPal\WhmcsIntegration\Repository\SelfService\BaseSelfServiceRepository
{
    /**
     * @return Settings
     * @throws InvalidApiResponse
     */
    public function get() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings
    {
        return $this->callAndMapException(function () {
            return $this->getApi()->getSettings();
        }, 'getSettings');
    }
}
