<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi;
use SupportPal\WhmcsIntegration\Repository\BaseRepository;
/**
 * Class BaseTicketRepository
 * @package SupportPal\WhmcsIntegration\Repository\Ticket
 */
abstract class BaseTicketRepository extends \SupportPal\WhmcsIntegration\Repository\BaseRepository
{
    /**
     * @return TicketApi
     * @throws Exception
     */
    protected function getApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi
    {
        return $this->getApiClientWrapper()->getSupportPal()->getTicketApi();
    }
}
