<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\ChannelSettings;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class ChannelSettingsRepository
 * @package SupportPal\WhmcsIntegration\Repository\Ticket
 */
class ChannelSettingsRepository extends \SupportPal\WhmcsIntegration\Repository\Ticket\BaseTicketRepository
{
    /**
     * @param string $name
     * @return ChannelSettings
     * @throws InvalidApiResponse
     */
    public function find(string $name) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\ChannelSettings
    {
        return $this->callAndMapException(function () use($name) {
            return $this->getApi()->getChannelSettings($name);
        }, 'getChannelSettings');
    }
}
