<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
class TicketAttachmentRepository extends \SupportPal\WhmcsIntegration\Repository\Ticket\BaseTicketRepository
{
    /**
     * @param int $id
     * @return Attachment
     * @throws InvalidApiResponse
     */
    public function find(int $id) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment
    {
        return $this->callAndMapException(function () use($id) {
            return $this->getApi()->getAttachment($id);
        }, 'getAttachment');
    }
    /**
     * @param Attachment $attachment
     * @return StreamInterface
     * @throws InvalidApiResponse
     * @throws MissingIdentifierException
     */
    public function download(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Attachment $attachment) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\StreamInterface
    {
        return $this->callAndMapException(function () use($attachment) {
            return $this->getApi()->downloadAttachment($attachment);
        }, 'downloadAttachment');
    }
}
