<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class TicketMessageRepository
 * @package SupportPal\WhmcsIntegration\Repository\Ticket
 */
class TicketMessageRepository extends \SupportPal\WhmcsIntegration\Repository\Ticket\BaseTicketRepository
{
    /**
     * @param int $ticketId
     * @param mixed[] $parameters
     * @return Collection
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function findBy(int $ticketId, array $parameters) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($ticketId, $parameters) {
            return $this->getApi()->getMessages($ticketId, $parameters);
        }, 'getMessages');
    }
}
