<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Whmcs;

use WHMCS\Database\Capsule;
use WHMCS\Input\Sanitize;
use function is_numeric;
class ModSupportPalRepository
{
    private const TABLE_NAME = 'mod_supportpal';
    public function getDefaultBrand() : ?int
    {
        return $this->getInt('brand_id');
    }
    public function getDefaultApiToken() : ?string
    {
        $token = $this->get('api_token');
        if ($token !== null) {
            return (string) \WHMCS\Input\Sanitize::decode($token);
        }
        return null;
    }
    public function getDefaultBaseUrl() : ?string
    {
        return $this->get('base_url');
    }
    public function get(string $key) : ?string
    {
        $object = \WHMCS\Database\Capsule::table(self::TABLE_NAME)->where('name', $key)->first(['value']);
        return data_get($object, 'value');
    }
    public function getInt(string $key) : ?int
    {
        $value = $this->get($key);
        return \is_numeric($value) ? (int) $value : null;
    }
    public function getBool(string $key) : ?bool
    {
        return ($string = $this->get($key)) !== null ? (bool) $string : null;
    }
    public function selfServiceTypeEnabled(string $section) : bool
    {
        return $this->getBool($section . '_enabled') ?? \true;
    }
}
