<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Whmcs;

use Illuminate\Support\Collection;
use WHMCS\Database\Capsule;
/**
 * Class WhmcsCustomFieldsRepository
 * @package SupportPal\WhmcsIntegration\Repository\Whmcs
 */
class WhmcsCustomFieldsRepository
{
    private const TABLE_NAME = 'tblcustomfields';
    /**
     * @param string $field
     * @param mixed[] $values
     * @return Collection<object>
     */
    public function findBy(string $field, array $values) : \Illuminate\Support\Collection
    {
        return \WHMCS\Database\Capsule::table(self::TABLE_NAME)->whereIn($field, $values)->get();
    }
}
