<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Router;

use SupportPal\WhmcsIntegration\Controller\ValidateIntegrationSettingsController;
use SupportPal\WhmcsIntegration\Request\Request;
use function array_filter;
use function array_values;
class IntegrationSettingsValidationRouter
{
    /** @var ValidateIntegrationSettingsController */
    private $integrationSettingsController;
    public function __construct(\SupportPal\WhmcsIntegration\Controller\ValidateIntegrationSettingsController $integrationSettingsController)
    {
        $this->integrationSettingsController = $integrationSettingsController;
    }
    public function route(\SupportPal\WhmcsIntegration\Request\Request $request, int $brandId) : void
    {
        $announcementsId = (int) $request->get('announcements_id');
        $knowledgeBaseId = (int) $request->get('knowledgebase_id');
        $downloadsId = (int) $request->get('downloads_id');
        if ($this->isValidateSelfServiceTypes($announcementsId, $knowledgeBaseId, $downloadsId)) {
            $this->integrationSettingsController->validateIdsBelongsToBrand($request, \array_values(\array_filter([$announcementsId, $knowledgeBaseId, $downloadsId])), $brandId);
            return;
        }
        $this->integrationSettingsController->validateAuthentication($request, $brandId);
    }
    /**
     * @param int $announcementsId
     * @param int $knowledgeBaseId
     * @param int $downloadsId
     * @return bool
     */
    private function isValidateSelfServiceTypes(int $announcementsId, int $knowledgeBaseId, int $downloadsId)
    {
        return $announcementsId !== 0 || $knowledgeBaseId !== 0 || $downloadsId !== 0;
    }
}
