<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Router;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Controller\SelfService\BaseSelfServiceController;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\Helper\Paginator;
use SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Request\RequestParser;
class SelfServiceRouter
{
    /** @var RequestParser */
    private $requestParser;
    /** @var ModSupportPalRepository */
    private $modSupportPalRepository;
    /** @var Paginator */
    private $paginator;
    public function __construct(\SupportPal\WhmcsIntegration\Request\RequestParser $requestParser, \SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository $repository, \SupportPal\WhmcsIntegration\Helper\Paginator $paginator)
    {
        $this->requestParser = $requestParser;
        $this->modSupportPalRepository = $repository;
        $this->paginator = $paginator;
    }
    /**
     * @param BaseSelfServiceController $baseSelfServiceController
     * @param Request $request
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function route(\SupportPal\WhmcsIntegration\Controller\SelfService\BaseSelfServiceController $baseSelfServiceController, \SupportPal\WhmcsIntegration\Request\Request $request) : void
    {
        if (!$this->modSupportPalRepository->selfServiceTypeEnabled($baseSelfServiceController->getTypeName())) {
            return;
        }
        $id = $this->getId($request);
        $categoryId = $this->getCategoryId($request);
        $tagId = $this->getTagId($request);
        $search = $request->get('search', null);
        if ($id !== null) {
            $baseSelfServiceController->showOneById($id, $request);
        } elseif ($categoryId !== null || $tagId !== null || $search !== null) {
            $baseSelfServiceController->showFilteredArticles($search, $tagId, $categoryId, $this->getPage($request));
        } else {
            $baseSelfServiceController->showAll($request);
        }
    }
    private function getId(\SupportPal\WhmcsIntegration\Request\Request $request) : ?int
    {
        $id = $this->requestParser->parseIntOrNull($request, 'announcement');
        if ($id !== null) {
            return $id;
        }
        return $this->requestParser->parseIntOrNull($request, 'id');
    }
    private function getCategoryId(\SupportPal\WhmcsIntegration\Request\Request $request) : ?int
    {
        return $this->requestParser->parseIntOrNull($request, 'category');
    }
    private function getTagId(\SupportPal\WhmcsIntegration\Request\Request $request) : ?int
    {
        return $this->requestParser->parseIntOrNull($request, 'tag');
    }
    private function getPage(\SupportPal\WhmcsIntegration\Request\Request $request) : int
    {
        return $this->paginator->current($request);
    }
}
