<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Router;

use SupportPal\WhmcsIntegration\Controller\Ticket\SubmitTicketController;
use SupportPal\WhmcsIntegration\Request\Request;
/**
 * Class TicketRouter
 * @package SupportPal\WhmcsIntegration\Router
 */
class TicketRouter
{
    /**
     * @param SubmitTicketController $submitTicketController
     * @param Request $request
     */
    public function route(\SupportPal\WhmcsIntegration\Controller\Ticket\SubmitTicketController $submitTicketController, \SupportPal\WhmcsIntegration\Request\Request $request) : void
    {
        $step = $request->get('step', '1');
        if ($step === '1') {
            $submitTicketController->selectDepartmentsPage();
        } elseif ($step === '2') {
            $submitTicketController->submitTicketPage($request);
        } elseif ($step === 'confirm') {
            $submitTicketController->confirmPage($request);
        }
    }
}
