<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Service\Manager\SelfService;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfServiceApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Request\CreateComment;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\SupportPalApiClientWrapper;
/**
 * Class CommentManager
 * @package SupportPal\WhmcsIntegration\Service\Manager\SelfService
 */
class CommentManager
{
    /** @var SelfServiceApi */
    private $selfServiceApi;
    /**
     * CommentManager constructor.
     * @param SupportPalApiClientWrapper $apiClientWrapper
     * @throws Exception
     */
    public function __construct(\SupportPal\WhmcsIntegration\SupportPalApiClientWrapper $apiClientWrapper)
    {
        $this->selfServiceApi = $apiClientWrapper->getSupportPal()->getSelfServiceApi();
    }
    /**
     * Post a comment
     *
     * @param mixed[] $comment
     * @param mixed[] $selfServiceSettings
     * @param mixed[]|null $helpDeskUser
     * @return Comment
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function createComment(array $comment, array $selfServiceSettings, ?array $helpDeskUser = null) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment
    {
        $status = isset($selfServiceSettings['comment_moderation']) && $selfServiceSettings['comment_moderation'] === '0' ? 1 : 0;
        $notify_reply = isset($comment['comment_email_author']) && $comment['comment_email_author'] === 'on' ? 1 : 0;
        $commentData = ['text' => $comment['comment_message'], 'article_id' => (int) $comment['comment_item_id'], 'type_id' => (int) $comment['comment_type_id'], 'parent_id' => !empty($comment['comment_parent_id']) ? (int) $comment['comment_parent_id'] : null, 'status' => $status, 'notify_reply' => $notify_reply];
        /** If we have an account or need to use the name **/
        if ($helpDeskUser !== null) {
            $commentData['author_id'] = $helpDeskUser['id'];
        } else {
            $commentData['name'] = $comment['comment_name'];
        }
        /** @var CreateComment $createComment */
        $createComment = (new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Request\CreateComment())->fill($commentData);
        try {
            return $this->selfServiceApi->postComment($createComment);
        } catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\InvalidApiResponse($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
    }
}
