<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Service\Manager\Ticket;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\TicketApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateMessage;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\SupportPalApiClientWrapper;
/**
 * Class MessageManager
 * @package SupportPal\WhmcsIntegration\Service\Manager\Ticket
 */
class MessageManager
{
    /** @var TicketApi */
    private $ticketApi;
    /**
     * MessageManager constructor.
     * @param SupportPalApiClientWrapper $apiClient
     * @throws Exception
     */
    public function __construct(\SupportPal\WhmcsIntegration\SupportPalApiClientWrapper $apiClient)
    {
        $this->ticketApi = $apiClient->getSupportPal()->getTicketApi();
    }
    /**
     * @param mixed[] $data
     * @return Message
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function create(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message
    {
        /** @var CreateMessage $createMessage */
        $createMessage = (new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateMessage())->fill($data);
        try {
            return $this->ticketApi->postMessage($createMessage);
        } catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\InvalidApiResponse($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
    }
}
