<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Service\Manager;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Request\CreateUser;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\SupportPalApiClientWrapper;
/**
 * Class UserManager
 * @package SupportPal\WhmcsIntegration\Service\Manager
 */
class UserManager
{
    /** @var UserApi */
    private $userApi;
    /**
     * UserManager constructor.
     * @param SupportPalApiClientWrapper $apiClient
     * @throws Exception
     */
    public function __construct(\SupportPal\WhmcsIntegration\SupportPalApiClientWrapper $apiClient)
    {
        $this->userApi = $apiClient->getSupportPal()->getUserApi();
    }
    /**
     * @param User $user
     * @param mixed[] $data
     * @return User
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function update(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User $user, array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User
    {
        try {
            return $this->userApi->updateUser($user, $data);
        } catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\InvalidApiResponse($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
    }
    /**
     * @param mixed[] $data
     * @return User
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function create(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User
    {
        /** @var CreateUser $createUser */
        $createUser = (new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Request\CreateUser())->fill($data);
        try {
            return $this->userApi->postUser($createUser);
        } catch (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\InvalidApiResponse($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
    }
}
