<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Validator;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\Exception\ValidationException;
use SupportPal\WhmcsIntegration\Repository\SelfService\ArticleTypeRepository;
use function array_filter;
use function array_map;
use function implode;
use function in_array;
use function sprintf;
class ArticleTypeIdBelongsToBrandValidator
{
    /** @var ArticleTypeRepository */
    private $articleTypeRepository;
    public function __construct(\SupportPal\WhmcsIntegration\Repository\SelfService\ArticleTypeRepository $articleTypeRepository)
    {
        $this->articleTypeRepository = $articleTypeRepository;
    }
    /**
     * @param int[] $typeIds
     * @param int $brandId
     * @throws ValidationException
     * @throws InvalidArgumentException
     */
    public function validateMany(array $typeIds, int $brandId) : void
    {
        try {
            $typesCollection = $this->articleTypeRepository->findBy(['brand_id' => $brandId]);
        } catch (\SupportPal\WhmcsIntegration\Exception\InvalidApiResponse $exception) {
            throw new \SupportPal\WhmcsIntegration\Exception\ValidationException($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
        $helpDeskSelfServiceTypes = \array_map(function (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type $type) {
            return $type->getId();
        }, $typesCollection->getModels());
        $invalidIds = \array_filter($typeIds, function (int $typeId) use($helpDeskSelfServiceTypes) {
            return !\in_array($typeId, $helpDeskSelfServiceTypes);
        });
        if (!empty($invalidIds)) {
            $errorMessage = \sprintf('The following type ids: %s does not belong to brand id: %d', \implode(', ', $invalidIds), $brandId);
            throw new \SupportPal\WhmcsIntegration\Exception\ValidationException($errorMessage);
        }
    }
}
