<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Validator;

use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\Exception\ValidationException;
use SupportPal\WhmcsIntegration\Repository\Core\BrandRepository;
class AuthenticationValidator
{
    /** @var BrandRepository */
    private $brandRepository;
    public function __construct(\SupportPal\WhmcsIntegration\Repository\Core\BrandRepository $brandRepository)
    {
        $this->brandRepository = $brandRepository;
    }
    /** @throws ValidationException */
    public function validate(int $brandId) : void
    {
        try {
            $this->brandRepository->find($brandId);
        } catch (\SupportPal\WhmcsIntegration\Exception\InvalidApiResponse $invalidApiResponse) {
            throw new \SupportPal\WhmcsIntegration\Exception\ValidationException($invalidApiResponse->getMessage(), $invalidApiResponse->getCode(), $invalidApiResponse->getPrevious());
        }
    }
}
