<?php

namespace SupportPal\WhmcsIntegration\Vendor\GuzzleHttp;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\MessageInterface;
final class BodySummarizer implements \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\BodySummarizerInterface
{
    /**
     * @var int|null
     */
    private $truncateAt;
    public function __construct(int $truncateAt = null)
    {
        $this->truncateAt = $truncateAt;
    }
    /**
     * Returns a summarized message body.
     */
    public function summarize(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\MessageInterface $message) : ?string
    {
        return $this->truncateAt === null ? \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Message::bodySummary($message) : \SupportPal\WhmcsIntegration\Vendor\GuzzleHttp\Psr7\Message::bodySummary($message, $this->truncateAt);
    }
}
