<?php

namespace SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage;

use SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry;
class CompressedDoctrineCacheStorage implements \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\CacheStorageInterface
{
    /**
     * @var Cache
     */
    protected $cache;
    /**
     * @param Cache $cache
     */
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Doctrine\Common\Cache\Cache $cache)
    {
        $this->cache = $cache;
    }
    /**
     * {@inheritdoc}
     */
    public function fetch($key)
    {
        try {
            $cache = \unserialize(\gzuncompress($this->cache->fetch($key)));
            if ($cache instanceof \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry) {
                return $cache;
            }
        } catch (\Exception $ignored) {
            return;
        }
        return;
    }
    /**
     * {@inheritdoc}
     */
    public function save($key, \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry $data)
    {
        try {
            $lifeTime = $data->getTTL();
            if ($lifeTime >= 0) {
                return $this->cache->save($key, \gzcompress(\serialize($data)), $lifeTime);
            }
        } catch (\Exception $ignored) {
            // No fail if we can't save it the storage
        }
        return \false;
    }
    /**
     * {@inheritdoc}
     */
    public function delete($key)
    {
        try {
            return $this->cache->delete($key);
        } catch (\Exception $ignored) {
            // Don't fail if we can't delete it
        }
        return \false;
    }
}
