<?php

namespace SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage;

use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry;
use SupportPal\WhmcsIntegration\Vendor\Psr\SimpleCache\CacheInterface;
class Psr16CacheStorage implements \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\CacheStorageInterface
{
    /**
     * @var CacheInterface
     */
    private $cache;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Psr\SimpleCache\CacheInterface $cache)
    {
        $this->cache = $cache;
    }
    /**
     * {@inheritdoc}
     */
    public function fetch($key)
    {
        $data = $this->cache->get($key);
        if ($data instanceof \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry) {
            return $data;
        }
        return null;
    }
    /**
     * {@inheritdoc}
     */
    public function save($key, \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry $data)
    {
        $ttl = $data->getTTL();
        if ($ttl === 0) {
            return $this->cache->set($key, $data);
        }
        return $this->cache->set($key, $data, $data->getTTL());
    }
    /**
     * {@inheritdoc}
     */
    public function delete($key)
    {
        return $this->cache->delete($key);
    }
}
