<?php

namespace SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\Delegate;

use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\NullCacheStrategy;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
class DelegatingCacheStrategy implements \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface
{
    /**
     * @var array
     */
    private $requestMatchers = [];
    /**
     * @var CacheStrategyInterface
     */
    private $defaultCacheStrategy;
    /**
     * DelegatingCacheStrategy constructor.
     */
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface $defaultCacheStrategy = null)
    {
        $this->defaultCacheStrategy = $defaultCacheStrategy ?: new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\NullCacheStrategy();
    }
    /**
     * @param CacheStrategyInterface $defaultCacheStrategy
     */
    public function setDefaultCacheStrategy(\SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface $defaultCacheStrategy)
    {
        $this->defaultCacheStrategy = $defaultCacheStrategy;
    }
    /**
     * @param RequestMatcherInterface $requestMatcher
     * @param CacheStrategyInterface  $cacheStrategy
     */
    public final function registerRequestMatcher(\SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\Delegate\RequestMatcherInterface $requestMatcher, \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\CacheStrategyInterface $cacheStrategy)
    {
        $this->requestMatchers[] = [$requestMatcher, $cacheStrategy];
    }
    /**
     * @param RequestInterface $request
     * @return CacheStrategyInterface
     */
    private function getStrategyFor(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request)
    {
        /**
         * @var RequestMatcherInterface $requestMatcher
         * @var CacheStrategyInterface $cacheStrategy
         */
        foreach ($this->requestMatchers as $requestMatcher) {
            list($requestMatcher, $cacheStrategy) = $requestMatcher;
            if ($requestMatcher->matches($request)) {
                return $cacheStrategy;
            }
        }
        return $this->defaultCacheStrategy;
    }
    /**
     * @inheritDoc
     */
    public function fetch(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request)
    {
        return $this->getStrategyFor($request)->fetch($request);
    }
    /**
     * @inheritDoc
     */
    public function cache(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response)
    {
        return $this->getStrategyFor($request)->cache($request, $response);
    }
    /**
     * @inheritDoc
     */
    public function update(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response)
    {
        return $this->getStrategyFor($request)->update($request, $response);
    }
    /**
     * {@inheritdoc}
     */
    public function delete(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request)
    {
        return $this->getStrategyFor($request)->delete($request);
    }
}
