<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link      http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoTypes;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Array_;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Mixed_;
/**
 * Value Object representing the type 'list'.
 *
 * @psalm-immutable
 */
final class List_ extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Array_ implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType
{
    public function underlyingType() : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type
    {
        return new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Array_();
    }
    public function __construct(?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type $valueType = null)
    {
        parent::__construct($valueType, new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer());
    }
    /**
     * Returns a rendered output of the Type as it would be used in a DocBlock.
     */
    public function __toString() : string
    {
        if ($this->valueType instanceof \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Mixed_) {
            return 'list';
        }
        return 'list<' . $this->valueType . '>';
    }
}
