<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link      http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoTypes;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\String_;
/**
 * Value Object representing the type 'string'.
 *
 * @psalm-immutable
 */
final class NumericString extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\String_ implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType
{
    public function underlyingType() : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type
    {
        return new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\String_();
    }
    /**
     * Returns a rendered output of the Type as it would be used in a DocBlock.
     */
    public function __toString() : string
    {
        return 'numeric-string';
    }
}
