<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link      http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoTypes;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\AggregatedType;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Compound;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Float_;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer;
/**
 * Value Object representing the 'numeric' pseudo-type, which is either a numeric-string, integer or float.
 *
 * @psalm-immutable
 */
final class Numeric_ extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\AggregatedType implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType
{
    public function __construct()
    {
        \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\AggregatedType::__construct([new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoTypes\NumericString(), new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer(), new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Float_()], '|');
    }
    public function underlyingType() : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type
    {
        return new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Compound([new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoTypes\NumericString(), new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer(), new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Float_()]);
    }
    /**
     * Returns a rendered output of the Type as it would be used in a DocBlock.
     */
    public function __toString() : string
    {
        return 'numeric';
    }
}
