<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link https://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoTypes;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Boolean;
use function class_alias;
/**
 * Value Object representing the PseudoType 'False', which is a Boolean type.
 *
 * @psalm-immutable
 */
final class True_ extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Boolean implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType
{
    public function underlyingType() : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type
    {
        return new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Boolean();
    }
    public function __toString() : string
    {
        return 'true';
    }
}
\class_alias('SupportPal\\WhmcsIntegration\\Vendor\\phpDocumentor\\Reflection\\PseudoTypes\\True_', 'SupportPal\\WhmcsIntegration\\Vendor\\phpDocumentor\\Reflection\\Types\\True_', \false);
