<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link      http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type;
/**
 * Value Object representing a array-key Type.
 *
 * A array-key Type is the supertype (but not a union) of int and string.
 *
 * @psalm-immutable
 */
final class ArrayKey extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\AggregatedType implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\PseudoType
{
    public function __construct()
    {
        parent::__construct([new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\String_(), new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer()], '|');
    }
    public function underlyingType() : \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type
    {
        return new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Compound([new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\String_(), new \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Integer()]);
    }
    public function __toString() : string
    {
        return 'array-key';
    }
}
