<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Core;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\CoreApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Core\Brand;
use function array_map;
trait BrandApis
{
    use ApiAware;
    /**
     * @param int $brandId
     * @return Brand
     * @throws HttpResponseException
     */
    public function getBrand(int $brandId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Core\Brand
    {
        $response = $this->getApiClient()->getBrand($brandId);
        return $this->createBrand($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getBrands(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getBrands($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createBrand'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param array<mixed> $data
     * @return Brand
     */
    private function createBrand(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Core\Brand
    {
        /** @var Brand $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Core\Brand::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\CoreApiClient;
}
