<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Request\CreateComment;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException;
use function array_map;
/**
 * Trait CommentApis, includes all related ApiCalls pre and post processing to comments
 * @package SupportPal\ApiClient\Api\SelfService
 */
trait CommentApis
{
    use ApiAware;
    /**
     * This method creates a comment in SupportPal
     * @param CreateComment $comment
     * @return Comment
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function postComment(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Request\CreateComment $comment) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment
    {
        try {
            $commentArray = $this->getModelToArrayConverter()->convertOne($comment);
        } catch (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException $exception) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
        $response = $this->getApiClient()->postComment($commentArray);
        return $this->createComment($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getComments(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getComments($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createComment'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $commentId
     * @return Comment
     * @throws HttpResponseException
     */
    public function getComment(int $commentId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment
    {
        $response = $this->getApiClient()->getComment($commentId);
        return $this->createComment($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Comment
     */
    private function createComment(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment
    {
        /** @var Comment $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Comment::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
}
