<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings;
/**
 * Trait SettingsApis, includes all related ApiCalls pre and post processing to selfservice settings
 * @package SupportPal\ApiClient\Api\SelfService
 */
trait SettingsApis
{
    use ApiAware;
    /**
     * @return Settings
     * @throws HttpResponseException
     */
    public function getSettings() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings
    {
        $response = $this->getApiClient()->getSettings();
        /** @var Settings $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings::class, $this->decodeBody($response)['data']);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
}
