<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService\ArticleApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService\CategoryApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService\CommentApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService\SettingsApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService\TagApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService\TypeApis;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
/**
 * Contains all ApiCalls pre and post processing that falls under SelfService Module
 * Trait SelfServiceApis
 * @package SupportPal\ApiClient\Api
 */
class SelfServiceApi extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Api
{
    use ArticleApis;
    use CategoryApis;
    use CommentApis;
    use SettingsApis;
    use TagApis;
    use TypeApis;
    /** @var SelfServiceApiClient */
    protected $apiClient;
    /**
     * @return SelfServiceApiClient
     */
    protected function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient
    {
        return $this->apiClient;
    }
}
