<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\ChannelSettings;
/**
 * Trait ChannelSettingsApis, includes all related apis to ticket channels
 * @package SupportPal\ApiClient\Api\Ticket
 */
trait ChannelSettingsApis
{
    use ApiAware;
    /**
     * @param string $channel
     * @return ChannelSettings
     * @throws HttpResponseException
     */
    public function getChannelSettings(string $channel) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\ChannelSettings
    {
        $response = $this->getApiClient()->getChannelSettings($channel);
        /** @var ChannelSettings $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\ChannelSettings::class, $this->decodeBody($response)['data']);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
