<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateMessage;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException;
use function array_map;
trait MessageApis
{
    use ApiAware;
    /**
     * @param CreateMessage $message
     * @return Message
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function postMessage(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateMessage $message) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message
    {
        try {
            $messageArray = $this->getModelToArrayConverter()->convertOne($message);
        } catch (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException $exception) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
        $response = $this->getApiClient()->postMessage($messageArray);
        return $this->createMessage($this->decodeBody($response)['data']);
    }
    /**
     * @param int $ticketId
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getMessages(int $ticketId, array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $queryParameters['ticket_id'] = $ticketId;
        $response = $this->getApiClient()->getMessages($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createMessage'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $messageId
     * @return Message
     * @throws HttpResponseException
     */
    public function getMessage(int $messageId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message
    {
        $response = $this->getApiClient()->getMessage($messageId);
        return $this->createMessage($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Message
     */
    private function createMessage(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message
    {
        /** @var Message $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Message::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
