<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Status;
use function array_map;
trait StatusApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getStatuses(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getStatuses($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createStatus'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $statusId
     * @return Status
     * @throws HttpResponseException
     */
    public function getStatus(int $statusId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Status
    {
        $response = $this->getApiClient()->getStatus($statusId);
        return $this->createStatus($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Status
     */
    private function createStatus(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Status
    {
        /** @var Status $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Status::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
