<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateTicket;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException;
use TypeError;
use function array_map;
trait TicketApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getTickets(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getTickets($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createTicket'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $ticketId
     * @return Ticket
     * @throws HttpResponseException
     */
    public function getTicket(int $ticketId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket
    {
        $response = $this->getApiClient()->getTicket($ticketId);
        return $this->createTicket($this->decodeBody($response)['data']);
    }
    /**
     * @param Ticket $ticket
     * @param array<mixed> $data
     * @return Ticket
     * @throws InvalidArgumentException
     * @throws HttpResponseException
     */
    public function updateTicket(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket $ticket, array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket
    {
        try {
            $ticketId = $ticket->getId();
        } catch (\TypeError $typeError) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException('missing ticket identifier');
        }
        $response = $this->getApiClient()->updateTicket($ticketId, $data);
        return $this->createTicket($this->decodeBody($response)['data']);
    }
    /**
     * @param CreateTicket $createTicket
     * @return Ticket
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function postTicket(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Request\CreateTicket $createTicket) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket
    {
        try {
            $ticketArray = $this->getModelToArrayConverter()->convertOne($createTicket);
        } catch (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException $exception) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
        $response = $this->getApiClient()->postTicket($ticketArray);
        return $this->createTicket($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Ticket
     */
    private function createTicket(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket
    {
        /** @var Ticket $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Ticket::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
