<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\User;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Request\CreateUser;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException;
use TypeError;
use function array_map;
trait UserApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getUsers(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getUsers($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createUser'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $userId
     * @return User
     * @throws HttpResponseException
     */
    public function getUser(int $userId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User
    {
        $response = $this->getApiClient()->getUser($userId);
        return $this->createUser($this->decodeBody($response)['data']);
    }
    /**
     * @param User $user
     * @param array<mixed> $data
     * @return User
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function updateUser(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User $user, array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User
    {
        try {
            $userId = $user->getId();
        } catch (\TypeError $typeError) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\MissingIdentifierException('missing user identifier');
        }
        $response = $this->getApiClient()->updateUser($userId, $data);
        return $this->createUser($this->decodeBody($response)['data']);
    }
    /**
     * @param CreateUser $createUser
     * @return User
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function postUser(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\Request\CreateUser $createUser) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User
    {
        try {
            $userArray = $this->getModelToArrayConverter()->convertOne($createUser);
        } catch (\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\PropertyAccess\Exception\UninitializedPropertyException $exception) {
            throw new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException($exception->getMessage(), $exception->getCode(), $exception->getPrevious());
        }
        $response = $this->getApiClient()->postUser($userArray);
        return $this->createUser($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return User
     */
    private function createUser(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User
    {
        /** @var User $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
}
